/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Set;
import com.raizlabs.android.dbflow.structure.Model;

public class Update<TModel extends Model>
implements Query {
    private ConflictAction conflictAction = ConflictAction.NONE;
    private final Class<TModel> table;

    public Update(Class<TModel> table) {
        this.table = table;
    }

    public Update conflictAction(ConflictAction conflictAction) {
        this.conflictAction = conflictAction;
        return this;
    }

    public Update orRollback() {
        return this.conflictAction(ConflictAction.ROLLBACK);
    }

    public Update orAbort() {
        return this.conflictAction(ConflictAction.ABORT);
    }

    public Update orReplace() {
        return this.conflictAction(ConflictAction.REPLACE);
    }

    public Update orFail() {
        return this.conflictAction(ConflictAction.FAIL);
    }

    public Update orIgnore() {
        return this.conflictAction(ConflictAction.IGNORE);
    }

    public Set<TModel> set(SQLCondition ... conditions) {
        return new Set<TModel>(this, this.table).conditions(conditions);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"UPDATE ");
        if (this.conflictAction != null && !this.conflictAction.equals((Object)ConflictAction.NONE)) {
            queryBuilder.append((Object)"OR").appendSpaceSeparated((Object)this.conflictAction.name());
        }
        queryBuilder.append((Object)FlowManager.getTableName(this.table)).appendSpace();
        return queryBuilder.getQuery();
    }
}

