/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.Model;

public class CharProperty
extends BaseProperty<CharProperty> {
    public CharProperty(Class<? extends Model> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public CharProperty(Class<? extends Model> table, String columnName) {
        this(table, new NameAlias.Builder(columnName).build());
    }

    public CharProperty(Class<? extends Model> table, String columnName, String aliasName) {
        this(table, new NameAlias.Builder(columnName).as(aliasName).build());
    }

    @Override
    public CharProperty plus(IProperty iProperty) {
        return new CharProperty((Class<? extends Model>)this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public CharProperty minus(IProperty iProperty) {
        return new CharProperty((Class<? extends Model>)this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public CharProperty dividedBy(IProperty iProperty) {
        return new CharProperty((Class<? extends Model>)this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public CharProperty multipliedBy(IProperty iProperty) {
        return new CharProperty((Class<? extends Model>)this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public CharProperty mod(IProperty iProperty) {
        return new CharProperty((Class<? extends Model>)this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public CharProperty concatenate(IProperty iProperty) {
        return new CharProperty((Class<? extends Model>)this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public CharProperty as(String aliasName) {
        return new CharProperty((Class<? extends Model>)this.table, this.nameAlias.newBuilder().as(aliasName).build());
    }

    @Override
    public CharProperty distinct() {
        return new CharProperty((Class<? extends Model>)this.table, this.getDistinctAliasName());
    }

    @Override
    public CharProperty withTable(NameAlias tableNameAlias) {
        return new CharProperty((Class<? extends Model>)this.table, this.nameAlias.newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    public Condition is(char value) {
        return Condition.column(this.nameAlias).is(Character.valueOf(value));
    }

    public Condition eq(char value) {
        return Condition.column(this.nameAlias).eq(Character.valueOf(value));
    }

    public Condition isNot(char value) {
        return Condition.column(this.nameAlias).isNot(Character.valueOf(value));
    }

    public Condition notEq(char value) {
        return Condition.column(this.nameAlias).notEq(Character.valueOf(value));
    }

    public Condition like(char value) {
        return Condition.column(this.nameAlias).like(String.valueOf(value));
    }

    public Condition glob(char value) {
        return Condition.column(this.nameAlias).glob(String.valueOf(value));
    }

    public Condition greaterThan(char value) {
        return Condition.column(this.nameAlias).greaterThan(Character.valueOf(value));
    }

    public Condition greaterThanOrEq(char value) {
        return Condition.column(this.nameAlias).greaterThanOrEq(Character.valueOf(value));
    }

    public Condition lessThan(char value) {
        return Condition.column(this.nameAlias).lessThan(Character.valueOf(value));
    }

    public Condition lessThanOrEq(char value) {
        return Condition.column(this.nameAlias).lessThanOrEq(Character.valueOf(value));
    }

    public Condition.Between between(char value) {
        return Condition.column(this.nameAlias).between(Character.valueOf(value));
    }

    public Condition.In in(char firstValue, char ... values) {
        Condition.In in = Condition.column(this.nameAlias).in(Character.valueOf(firstValue), new Object[0]);
        for (char value : values) {
            in.and(Character.valueOf(value));
        }
        return in;
    }

    public Condition.In notIn(char firstValue, char ... values) {
        Condition.In in = Condition.column(this.nameAlias).notIn(Character.valueOf(firstValue), new Object[0]);
        for (char value : values) {
            in.and(Character.valueOf(value));
        }
        return in;
    }

    public Condition concatenate(char value) {
        return Condition.column(this.nameAlias).concatenate(Character.valueOf(value));
    }

    public Condition is(CharProperty property) {
        return Condition.column(this.nameAlias).is(property);
    }

    public Condition isNot(CharProperty property) {
        return Condition.column(this.nameAlias).isNot(property);
    }

    public Condition eq(CharProperty property) {
        return this.is(property);
    }

    public Condition notEq(CharProperty property) {
        return this.isNot(property);
    }

    public Condition greaterThan(CharProperty property) {
        return Condition.column(this.nameAlias).greaterThan(property);
    }

    public Condition greaterThanOrEq(CharProperty property) {
        return Condition.column(this.nameAlias).greaterThanOrEq(property);
    }

    public Condition lessThan(CharProperty property) {
        return Condition.column(this.nameAlias).lessThan(property);
    }

    public Condition lessThanOrEq(CharProperty property) {
        return Condition.column(this.nameAlias).lessThanOrEq(property);
    }
}

