/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.ITypeConditional;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.Model;
import java.util.Collection;

public class Property<T>
extends BaseProperty<Property<T>>
implements ITypeConditional<T> {
    public static final Property ALL_PROPERTY = new Property(null, "*"){

        @Override
        public String toString() {
            return this.nameAlias.nameRaw();
        }
    };

    public Property(Class<? extends Model> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public Property(Class<? extends Model> table, String columnName) {
        super(table, null);
        if (columnName != null) {
            this.nameAlias = new NameAlias.Builder(columnName).build();
        }
    }

    @Override
    public Property<T> plus(IProperty iProperty) {
        return new Property<T>((Class<? extends Model>)this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> minus(IProperty iProperty) {
        return new Property<T>((Class<? extends Model>)this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> dividedBy(IProperty iProperty) {
        return new Property<T>((Class<? extends Model>)this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> multipliedBy(IProperty iProperty) {
        return new Property<T>((Class<? extends Model>)this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> mod(IProperty iProperty) {
        return new Property<T>((Class<? extends Model>)this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> concatenate(IProperty iProperty) {
        return new Property<T>((Class<? extends Model>)this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> as(String aliasName) {
        return new Property<T>((Class<? extends Model>)this.table, this.getNameAlias().newBuilder().as(aliasName).build());
    }

    @Override
    public Property<T> distinct() {
        return new Property<T>((Class<? extends Model>)this.table, this.getDistinctAliasName());
    }

    @Override
    public Property<T> withTable(NameAlias tableNameAlias) {
        return new Property<T>((Class<? extends Model>)this.table, this.getNameAlias().newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    @Override
    public Condition is(T value) {
        return Condition.column(this.getNameAlias()).is(value);
    }

    @Override
    public Condition eq(T value) {
        return Condition.column(this.getNameAlias()).eq(value);
    }

    @Override
    public Condition isNot(T value) {
        return Condition.column(this.getNameAlias()).isNot(value);
    }

    @Override
    public Condition notEq(T value) {
        return Condition.column(this.getNameAlias()).notEq(value);
    }

    @Override
    public Condition like(String value) {
        return Condition.column(this.getNameAlias()).like(value);
    }

    @Override
    public Condition glob(String value) {
        return Condition.column(this.getNameAlias()).glob(value);
    }

    @Override
    public Condition greaterThan(T value) {
        return Condition.column(this.getNameAlias()).greaterThan(value);
    }

    @Override
    public Condition greaterThanOrEq(T value) {
        return Condition.column(this.getNameAlias()).greaterThanOrEq(value);
    }

    @Override
    public Condition lessThan(T value) {
        return Condition.column(this.getNameAlias()).lessThan(value);
    }

    @Override
    public Condition lessThanOrEq(T value) {
        return Condition.column(this.getNameAlias()).lessThanOrEq(value);
    }

    @Override
    public Condition.Between between(T value) {
        return Condition.column(this.getNameAlias()).between(value);
    }

    @Override
    public Condition.In in(T firstValue, T ... values) {
        return Condition.column(this.getNameAlias()).in(firstValue, values);
    }

    @Override
    public Condition.In notIn(T firstValue, T ... values) {
        return Condition.column(this.getNameAlias()).notIn(firstValue, values);
    }

    @Override
    public Condition.In in(Collection<T> values) {
        return Condition.column(this.getNameAlias()).in(values);
    }

    @Override
    public Condition.In notIn(Collection<T> values) {
        return Condition.column(this.getNameAlias()).notIn(values);
    }

    @Override
    public Condition concatenate(T value) {
        return Condition.column(this.getNameAlias()).concatenate(value);
    }
}

