/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.ByteProperty;
import com.raizlabs.android.dbflow.sql.language.property.CharProperty;
import com.raizlabs.android.dbflow.sql.language.property.DoubleProperty;
import com.raizlabs.android.dbflow.sql.language.property.FloatProperty;
import com.raizlabs.android.dbflow.sql.language.property.IntProperty;
import com.raizlabs.android.dbflow.sql.language.property.LongProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.sql.language.property.ShortProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.Model;

public class PropertyFactory {
    public static CharProperty from(char c) {
        return new CharProperty(null, NameAlias.rawBuilder("'" + c + "'").build());
    }

    public static IntProperty from(int i) {
        return new IntProperty(null, NameAlias.rawBuilder(i + "").build());
    }

    public static DoubleProperty from(double d) {
        return new DoubleProperty(null, NameAlias.rawBuilder(d + "").build());
    }

    public static LongProperty from(long l) {
        return new LongProperty(null, NameAlias.rawBuilder(l + "").build());
    }

    public static FloatProperty from(float f) {
        return new FloatProperty(null, NameAlias.rawBuilder(f + "").build());
    }

    public static ShortProperty from(short s) {
        return new ShortProperty(null, NameAlias.rawBuilder(s + "").build());
    }

    public static ByteProperty from(byte b) {
        return new ByteProperty(null, NameAlias.rawBuilder(b + "").build());
    }

    public static <T> Property<T> from(@Nullable T type) {
        return new Property(null, NameAlias.rawBuilder(Condition.convertValueToString(type)).build());
    }

    public static <TModel extends Model> Property<TModel> from(@NonNull ModelQueriable<TModel> queriable) {
        return PropertyFactory.from(queriable.getTable(), "(" + String.valueOf(queriable.getQuery()).trim() + ")");
    }

    public static <T> Property<T> from(@Nullable Class<T> type, String stringRepresentation) {
        return new Property(null, NameAlias.rawBuilder(stringRepresentation).build());
    }
}

