/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.migration;

import android.database.Cursor;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SQLiteType;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.migration.BaseMigration;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.List;

public class AlterTableMigration<TModel extends Model>
extends BaseMigration {
    private final Class<TModel> table;
    private QueryBuilder query;
    private QueryBuilder renameQuery;
    private List<QueryBuilder> columnDefinitions;
    private List<String> columnNames;
    private String oldTableName;

    public AlterTableMigration(Class<TModel> table) {
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void migrate(DatabaseWrapper database) {
        Cursor cursorToCheckColumnFor;
        String sql = this.getAlterTableQueryBuilder().getQuery();
        String tableName = FlowManager.getTableName(this.table);
        if (this.renameQuery != null) {
            String renameQuery = new QueryBuilder((Object)sql).appendQuotedIfNeeded(this.oldTableName).append((Object)this.renameQuery.getQuery()).append((Object)tableName).toString();
            database.execSQL(renameQuery);
        }
        if (this.columnDefinitions != null && (cursorToCheckColumnFor = SQLite.select(new IProperty[0]).from(this.table).limit(0).query(database)) != null) {
            try {
                sql = new QueryBuilder((Object)sql).append((Object)tableName).toString();
                for (int i = 0; i < this.columnDefinitions.size(); ++i) {
                    QueryBuilder columnDefinition = this.columnDefinitions.get(i);
                    String columnName = QueryBuilder.stripQuotes((String)this.columnNames.get(i));
                    if (cursorToCheckColumnFor.getColumnIndex(columnName) != -1) continue;
                    database.execSQL(sql + " ADD COLUMN " + columnDefinition.getQuery());
                }
            }
            finally {
                cursorToCheckColumnFor.close();
            }
        }
    }

    @Override
    @CallSuper
    public void onPostMigrate() {
        this.query = null;
        this.renameQuery = null;
        this.columnDefinitions = null;
        this.columnNames = null;
    }

    public AlterTableMigration<TModel> renameFrom(@NonNull String oldName) {
        this.oldTableName = oldName;
        this.renameQuery = new QueryBuilder().append((Object)" RENAME").appendSpaceSeparated((Object)"TO");
        return this;
    }

    public AlterTableMigration<TModel> addColumn(@NonNull SQLiteType sqLiteType, @NonNull String columnName) {
        if (this.columnDefinitions == null) {
            this.columnDefinitions = new ArrayList<QueryBuilder>();
            this.columnNames = new ArrayList<String>();
        }
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)QueryBuilder.quoteIfNeeded((String)columnName)).appendSpace().appendSQLiteType(sqLiteType);
        this.columnDefinitions.add(queryBuilder);
        this.columnNames.add(columnName);
        return this;
    }

    public AlterTableMigration<TModel> addForeignKeyColumn(SQLiteType sqLiteType, String columnName, String referenceClause) {
        if (this.columnDefinitions == null) {
            this.columnDefinitions = new ArrayList<QueryBuilder>();
            this.columnNames = new ArrayList<String>();
        }
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)QueryBuilder.quoteIfNeeded((String)columnName)).appendSpace().appendSQLiteType(sqLiteType).appendSpace().append((Object)"REFERENCES ").append((Object)referenceClause);
        this.columnDefinitions.add(queryBuilder);
        this.columnNames.add(columnName);
        return this;
    }

    public String getRenameQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.getAlterTableQueryBuilder().getQuery()).appendQuotedIfNeeded(this.oldTableName).append((Object)this.renameQuery).append((Object)FlowManager.getTableName(this.table));
        return queryBuilder.getQuery();
    }

    public List<String> getColumnDefinitions() {
        String sql = new QueryBuilder((Object)this.getAlterTableQueryBuilder()).append((Object)FlowManager.getTableName(this.table)).toString();
        ArrayList<String> columnDefinitions = new ArrayList<String>();
        if (this.columnDefinitions != null) {
            for (QueryBuilder columnDefinition : this.columnDefinitions) {
                QueryBuilder queryBuilder = new QueryBuilder((Object)sql).appendSpaceSeparated((Object)"ADD COLUMN").append((Object)columnDefinition.getQuery());
                columnDefinitions.add(queryBuilder.getQuery());
            }
        }
        return columnDefinitions;
    }

    public QueryBuilder getAlterTableQueryBuilder() {
        if (this.query == null) {
            this.query = new QueryBuilder().append((Object)"ALTER").appendSpaceSeparated((Object)"TABLE");
        }
        return this.query;
    }
}

