/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.migration;

import android.support.annotation.CallSuper;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.migration.BaseMigration;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class UpdateTableMigration<TModel extends Model>
extends BaseMigration {
    private final Class<TModel> table;
    private ConditionGroup whereConditionGroup;
    private ConditionGroup setConditionGroup;

    public UpdateTableMigration(Class<TModel> table) {
        this.table = table;
    }

    public UpdateTableMigration<TModel> set(SQLCondition ... conditions) {
        if (this.setConditionGroup == null) {
            this.setConditionGroup = ConditionGroup.nonGroupingClause();
        }
        this.setConditionGroup.andAll(conditions);
        return this;
    }

    public UpdateTableMigration<TModel> where(SQLCondition ... conditions) {
        if (this.whereConditionGroup == null) {
            this.whereConditionGroup = ConditionGroup.nonGroupingClause();
        }
        this.whereConditionGroup.andAll(conditions);
        return this;
    }

    @Override
    public final void migrate(DatabaseWrapper database) {
        this.getUpdateStatement().execute(database);
    }

    @Override
    @CallSuper
    public void onPostMigrate() {
        this.setConditionGroup = null;
        this.whereConditionGroup = null;
    }

    public BaseQueriable<TModel> getUpdateStatement() {
        return SQLite.update(this.table).set(this.setConditionGroup).where(this.whereConditionGroup);
    }
}

