/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.saveable.ListModelSaver;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.RetrievalAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;

public class CacheableListModelSaver<TModel extends Model, TAdapter extends RetrievalAdapter>
extends ListModelSaver<TModel, TModel, TAdapter> {
    public CacheableListModelSaver(ModelSaver<TModel, TModel, TAdapter> modelSaver) {
        super(modelSaver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        try (DatabaseStatement statement = this.getModelSaver().getModelAdapter().getInsertStatement(wrapper);){
            for (Model model : tableCollection) {
                if (!this.getModelSaver().save(model, wrapper, statement, contentValues)) continue;
                this.getModelSaver().getModelAdapter().storeModelInCache(model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        try (DatabaseStatement statement = this.getModelSaver().getModelAdapter().getInsertStatement(wrapper);){
            for (Model model : tableCollection) {
                if (this.getModelSaver().insert(model, statement) <= 0L) continue;
                this.getModelSaver().getModelAdapter().storeModelInCache(model);
            }
        }
    }

    @Override
    public synchronized void updateAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        for (Model model : tableCollection) {
            if (!this.getModelSaver().update(model, wrapper, contentValues)) continue;
            this.getModelSaver().getModelAdapter().storeModelInCache(model);
        }
    }
}

