/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.RetrievalAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;

public class ListModelSaver<TModel extends Model, TTable extends Model, TAdapter extends RetrievalAdapter> {
    private final ModelSaver<TModel, TTable, TAdapter> modelSaver;

    public ListModelSaver(ModelSaver<TModel, TTable, TAdapter> modelSaver) {
        this.modelSaver = modelSaver;
    }

    public synchronized void saveAll(@NonNull Collection<TTable> tableCollection) {
        this.saveAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveAll(@NonNull Collection<TTable> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        try (DatabaseStatement statement = this.modelSaver.getModelAdapter().getInsertStatement(wrapper);){
            for (Model model : tableCollection) {
                this.modelSaver.save(model, wrapper, statement, contentValues);
            }
        }
    }

    public synchronized void insertAll(@NonNull Collection<TTable> tableCollection) {
        this.insertAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertAll(@NonNull Collection<TTable> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        try (DatabaseStatement statement = this.modelSaver.getModelAdapter().getInsertStatement(wrapper);){
            for (Model model : tableCollection) {
                this.modelSaver.insert(model, statement);
            }
        }
    }

    public synchronized void updateAll(@NonNull Collection<TTable> tableCollection) {
        this.saveAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    public synchronized void updateAll(@NonNull Collection<TTable> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        for (Model model : tableCollection) {
            this.modelSaver.update(model, wrapper, contentValues);
        }
    }

    public ModelSaver<TModel, TTable, TAdapter> getModelSaver() {
        return this.modelSaver;
    }
}

