/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.RetrievalAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class ModelSaver<TModel extends Model, TTable extends Model, TAdapter extends RetrievalAdapter> {
    private static final int INSERT_FAILED = -1;
    private ModelAdapter<TModel> modelAdapter;
    private TAdapter adapter;

    public void setModelAdapter(ModelAdapter<TModel> modelAdapter) {
        this.modelAdapter = modelAdapter;
    }

    public void setAdapter(TAdapter adapter) {
        this.adapter = adapter;
    }

    public synchronized boolean save(@NonNull TTable model) {
        return this.save(model, this.getWritableDatabase(), this.modelAdapter.getInsertStatement(), new ContentValues());
    }

    public synchronized boolean save(@NonNull TTable model, DatabaseWrapper wrapper) {
        return this.save(model, wrapper, this.modelAdapter.getInsertStatement(wrapper), new ContentValues());
    }

    public synchronized boolean save(@NonNull TTable model, DatabaseWrapper wrapper, DatabaseStatement insertStatement, ContentValues contentValues) {
        boolean exists = ((RetrievalAdapter)this.adapter).exists(model, wrapper);
        if (exists) {
            exists = this.update(model, wrapper, contentValues);
        }
        if (!exists) {
            boolean bl = exists = this.insert(model, insertStatement) > -1L;
        }
        if (exists) {
            SqlUtils.notifyModelChanged(model, this.adapter, this.modelAdapter, BaseModel.Action.SAVE);
        }
        return exists;
    }

    public synchronized boolean update(@NonNull TTable model) {
        return this.update(model, this.getWritableDatabase(), new ContentValues());
    }

    public synchronized boolean update(@NonNull TTable model, @NonNull DatabaseWrapper wrapper) {
        return this.update(model, wrapper, new ContentValues());
    }

    public synchronized boolean update(@NonNull TTable model, @NonNull DatabaseWrapper wrapper, @NonNull ContentValues contentValues) {
        boolean successful;
        ((InternalAdapter)this.adapter).bindToContentValues(contentValues, model);
        boolean bl = successful = wrapper.updateWithOnConflict(this.modelAdapter.getTableName(), contentValues, ((RetrievalAdapter)this.adapter).getPrimaryConditionClause(model).getQuery(), null, ConflictAction.getSQLiteDatabaseAlgorithmInt((ConflictAction)this.modelAdapter.getUpdateOnConflictAction())) != 0L;
        if (successful) {
            SqlUtils.notifyModelChanged(model, this.adapter, this.modelAdapter, BaseModel.Action.UPDATE);
        }
        return successful;
    }

    public synchronized long insert(@NonNull TTable model) {
        return this.insert(model, this.modelAdapter.getInsertStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long insert(@NonNull TTable model, @NonNull DatabaseWrapper wrapper) {
        long result = 0L;
        try (DatabaseStatement insertStatement = this.modelAdapter.getInsertStatement(wrapper);){
            result = this.insert(model, insertStatement);
        }
        return result;
    }

    public synchronized long insert(@NonNull TTable model, @NonNull DatabaseStatement insertStatement) {
        ((InternalAdapter)this.adapter).bindToInsertStatement(insertStatement, model);
        long id = insertStatement.executeInsert();
        if (id > -1L) {
            ((InternalAdapter)this.adapter).updateAutoIncrement(model, id);
            SqlUtils.notifyModelChanged(model, this.adapter, this.modelAdapter, BaseModel.Action.INSERT);
        }
        return id;
    }

    public synchronized boolean delete(@NonNull TTable model) {
        return this.delete(model, this.getWritableDatabase());
    }

    public synchronized boolean delete(@NonNull TTable model, @NonNull DatabaseWrapper wrapper) {
        boolean successful;
        boolean bl = successful = SQLite.delete(this.modelAdapter.getModelClass()).where(((RetrievalAdapter)this.adapter).getPrimaryConditionClause(model)).count(wrapper) != 0L;
        if (successful) {
            SqlUtils.notifyModelChanged(model, this.adapter, this.modelAdapter, BaseModel.Action.DELETE);
        }
        ((InternalAdapter)this.adapter).updateAutoIncrement(model, 0);
        return successful;
    }

    protected DatabaseWrapper getWritableDatabase() {
        return FlowManager.getDatabaseForTable(this.modelAdapter.getModelClass()).getWritableDatabase();
    }

    public TAdapter getAdapter() {
        return this.adapter;
    }

    public ModelAdapter<TModel> getModelAdapter() {
        return this.modelAdapter;
    }
}

