/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.trigger;

import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.trigger.TriggerMethod;
import com.raizlabs.android.dbflow.structure.Model;

public class CompletedTrigger<TModel extends Model>
implements Query {
    private TriggerMethod<TModel> triggerMethod;
    private Query triggerLogicQuery;

    CompletedTrigger(TriggerMethod<TModel> triggerMethod, Query triggerLogicQuery) {
        this.triggerMethod = triggerMethod;
        this.triggerLogicQuery = triggerLogicQuery;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.triggerMethod.getQuery());
        queryBuilder.append((Object)"\nBEGIN").append((Object)"\n").append((Object)this.triggerLogicQuery.getQuery()).append((Object)";").append((Object)"\nEND");
        return queryBuilder.getQuery();
    }

    public void enable() {
        DatabaseDefinition databaseDefinition = FlowManager.getDatabaseForTable(this.triggerMethod.onTable);
        databaseDefinition.getWritableDatabase().execSQL(this.getQuery());
    }

    public void disable() {
        SqlUtils.dropTrigger(this.triggerMethod.onTable, this.triggerMethod.trigger.triggerName);
    }
}

