/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.trigger;

import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.trigger.TriggerMethod;
import com.raizlabs.android.dbflow.structure.Model;

public class Trigger
implements Query {
    public static final String BEFORE = "BEFORE";
    public static final String AFTER = "AFTER";
    public static final String INSTEAD_OF = "INSTEAD OF";
    final String triggerName;
    String beforeOrAfter;
    boolean temporary;

    public static Trigger create(String triggerName) {
        return new Trigger(triggerName);
    }

    private Trigger(String triggerName) {
        this.triggerName = triggerName;
    }

    public Trigger temporary() {
        this.temporary = true;
        return this;
    }

    public Trigger after() {
        this.beforeOrAfter = AFTER;
        return this;
    }

    public Trigger before() {
        this.beforeOrAfter = BEFORE;
        return this;
    }

    public Trigger insteadOf() {
        this.beforeOrAfter = INSTEAD_OF;
        return this;
    }

    public <TModel extends Model> TriggerMethod<TModel> delete(Class<TModel> onTable) {
        return new TriggerMethod<TModel>(this, "DELETE", onTable, new IProperty[0]);
    }

    public <TModel extends Model> TriggerMethod<TModel> insert(Class<TModel> onTable) {
        return new TriggerMethod<TModel>(this, "INSERT", onTable, new IProperty[0]);
    }

    public <TModel extends Model> TriggerMethod<TModel> update(Class<TModel> onTable, IProperty ... properties) {
        return new TriggerMethod<TModel>(this, "UPDATE", onTable, properties);
    }

    public String getName() {
        return this.triggerName;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"CREATE ");
        if (this.temporary) {
            queryBuilder.append((Object)"TEMP ");
        }
        queryBuilder.append((Object)"TRIGGER IF NOT EXISTS ").appendQuotedIfNeeded(this.triggerName).appendSpace().appendOptional((Object)(" " + this.beforeOrAfter + " "));
        return queryBuilder.getQuery();
    }
}

