/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.BaseAsyncObject;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.lang.ref.WeakReference;

public class AsyncModel<TModel extends Model>
extends BaseAsyncObject<AsyncModel<TModel>>
implements Model {
    private final TModel model;
    private transient WeakReference<OnModelChangedListener<TModel>> onModelChangedListener;

    public AsyncModel(@NonNull TModel referenceModel) {
        super(referenceModel.getClass());
        this.model = referenceModel;
    }

    public AsyncModel<TModel> withListener(OnModelChangedListener<TModel> onModelChangedListener) {
        this.onModelChangedListener = new WeakReference<OnModelChangedListener<TModel>>(onModelChangedListener);
        return this;
    }

    @Override
    public void save() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model) {
                model.save();
            }
        }).add(this.model).build());
    }

    @Override
    public void delete() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model) {
                model.delete();
            }
        }).add(this.model).build());
    }

    @Override
    public void update() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model) {
                model.update();
            }
        }).add(this.model).build());
    }

    @Override
    public void insert() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model) {
                model.insert();
            }
        }).add(this.model).build());
    }

    @Override
    public boolean exists() {
        return this.model.exists();
    }

    @Override
    protected void onSuccess(Transaction transaction) {
        if (this.onModelChangedListener != null && this.onModelChangedListener.get() != null) {
            ((OnModelChangedListener)this.onModelChangedListener.get()).onModelChanged(this.model);
        }
    }

    public static interface OnModelChangedListener<T> {
        public void onModelChanged(T var1);
    }
}

