/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure;

import android.database.Cursor;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.DatabaseConfig;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.queriable.ListModelLoader;
import com.raizlabs.android.dbflow.sql.queriable.SingleModelLoader;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public abstract class RetrievalAdapter<TModel extends Model, TTable extends Model> {
    private SingleModelLoader<TTable> singleModelLoader;
    private ListModelLoader<TTable> listModelLoader;
    private TableConfig<TTable> tableConfig;

    public RetrievalAdapter(DatabaseDefinition databaseDefinition) {
        DatabaseConfig databaseConfig = FlowManager.getConfig().getConfigForDatabase(databaseDefinition.getAssociatedDatabaseClassFile());
        if (databaseConfig != null) {
            this.tableConfig = databaseConfig.getTableConfigForTable(this.getModelClass());
            if (this.tableConfig != null) {
                if (this.tableConfig.singleModelLoader() != null) {
                    this.singleModelLoader = this.tableConfig.singleModelLoader();
                }
                if (this.tableConfig.listModelLoader() != null) {
                    this.listModelLoader = this.tableConfig.listModelLoader();
                }
            }
        }
    }

    public abstract void loadFromCursor(Cursor var1, TModel var2);

    public boolean exists(TModel model) {
        return this.exists(model, FlowManager.getDatabaseForTable(this.getModelClass()).getWritableDatabase());
    }

    public abstract boolean exists(TModel var1, DatabaseWrapper var2);

    public abstract ConditionGroup getPrimaryConditionClause(TModel var1);

    public abstract Class<TTable> getModelClass();

    protected TableConfig<TTable> getTableConfig() {
        return this.tableConfig;
    }

    public ListModelLoader<TTable> getListModelLoader() {
        if (this.listModelLoader == null) {
            this.listModelLoader = this.createListModelLoader();
        }
        return this.listModelLoader;
    }

    protected ListModelLoader<TTable> createListModelLoader() {
        return new ListModelLoader<TTable>(this.getModelClass());
    }

    public SingleModelLoader<TTable> getSingleModelLoader() {
        if (this.singleModelLoader == null) {
            this.singleModelLoader = this.createSingleModelLoader();
        }
        return this.singleModelLoader;
    }

    public void setSingleModelLoader(@NonNull SingleModelLoader<TTable> singleModelLoader) {
        this.singleModelLoader = singleModelLoader;
    }

    public void setListModelLoader(@NonNull ListModelLoader<TTable> listModelLoader) {
        this.listModelLoader = listModelLoader;
    }

    protected SingleModelLoader<TTable> createSingleModelLoader() {
        return new SingleModelLoader<TTable>(this.getModelClass());
    }
}

