/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.cache;

import android.util.SparseArray;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;

public class SparseArrayBasedCache<TModel extends Model>
extends ModelCache<TModel, SparseArray<TModel>> {
    public SparseArrayBasedCache() {
        super(new SparseArray());
    }

    public SparseArrayBasedCache(int initialCapacity) {
        super(new SparseArray(initialCapacity));
    }

    public SparseArrayBasedCache(SparseArray<TModel> sparseArray) {
        super(sparseArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModel(Object id, TModel model) {
        if (id instanceof Number) {
            SparseArray sparseArray = (SparseArray)this.getCache();
            synchronized (sparseArray) {
                ((SparseArray)this.getCache()).put(((Number)id).intValue(), model);
            }
        } else {
            throw new IllegalArgumentException("A SparseArrayBasedCache must use an id that can cast to a Number to convert it into a int");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TModel removeModel(Object id) {
        TModel model = this.get(id);
        SparseArray sparseArray = (SparseArray)this.getCache();
        synchronized (sparseArray) {
            ((SparseArray)this.getCache()).remove(((Number)id).intValue());
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        SparseArray sparseArray = (SparseArray)this.getCache();
        synchronized (sparseArray) {
            ((SparseArray)this.getCache()).clear();
        }
    }

    @Override
    public void setCacheSize(int size) {
        FlowLog.log(FlowLog.Level.I, "The cache size for " + SparseArrayBasedCache.class.getSimpleName() + " is not re-configurable.");
    }

    @Override
    public TModel get(Object id) {
        if (id instanceof Number) {
            return (TModel)((Model)((SparseArray)this.getCache()).get(((Number)id).intValue()));
        }
        throw new IllegalArgumentException("A SparseArrayBasedCache uses an id that can cast to a Number to convert it into a int");
    }
}

