/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.container;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.InvalidDBConfiguration;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.container.ModelContainer;
import com.raizlabs.android.dbflow.structure.container.ModelContainerAdapter;
import java.util.Iterator;

public abstract class BaseModelContainer<TModel extends Model, DataClass>
implements ModelContainer<TModel, DataClass>,
Model {
    TModel model;
    ModelAdapter<TModel> modelAdapter;
    ModelContainerAdapter<TModel> modelContainerAdapter;
    DataClass data;

    public BaseModelContainer(Class<TModel> table) {
        this.modelAdapter = FlowManager.getModelAdapter(table);
        this.modelContainerAdapter = FlowManager.getContainerAdapter(table);
        if (this.modelContainerAdapter == null) {
            throw new InvalidDBConfiguration("The table " + FlowManager.getTableName(table) + " did not specify the " + com.raizlabs.android.dbflow.annotation.ModelContainer.class.getSimpleName() + " annotation." + " Please decorate " + table.getName() + " with annotation @" + com.raizlabs.android.dbflow.annotation.ModelContainer.class.getSimpleName() + ".");
        }
    }

    public BaseModelContainer(Class<TModel> table, DataClass data) {
        this(table);
        this.data = data;
    }

    public BaseModelContainer(@NonNull ModelContainer<TModel, ?> existingContainer) {
        this(existingContainer.getTable());
        Iterator<String> keys = existingContainer.iterator();
        if (keys != null) {
            while (keys.hasNext()) {
                String key = keys.next();
                this.put(key, existingContainer.getValue(key));
            }
        }
    }

    @Override
    public <T> T getTypeConvertedPropertyValue(Class<T> type, String key) {
        Object value = this.getValue(key);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        TypeConverter converter = FlowManager.getTypeConverterForClass(type);
        if (converter != null) {
            return (T)converter.getModelValue(value);
        }
        return null;
    }

    @Override
    @Nullable
    public TModel toModel() {
        if (this.model == null && this.data != null) {
            this.model = this.modelContainerAdapter.toModel(this);
        }
        return this.model;
    }

    @Override
    @Nullable
    public TModel toModelForce() {
        this.model = null;
        return this.toModel();
    }

    @Override
    @Nullable
    public TModel getModel() {
        return this.model;
    }

    public void setModel(TModel model) {
        this.model = model;
    }

    public void invalidateModel() {
        this.setModel(null);
    }

    @Override
    public abstract BaseModelContainer getInstance(Object var1, Class<? extends Model> var2);

    protected Object getModelValue(Object inValue, String columnName) {
        ModelContainerAdapter<TModel> modelContainerAdapter = FlowManager.getContainerAdapter(this.getTable());
        Class<?> columnClass = modelContainerAdapter.getClassForColumn(columnName);
        ModelContainerAdapter<?> columnAdapter = FlowManager.getContainerAdapter(columnClass);
        if (columnAdapter == null) {
            throw new RuntimeException("Column: " + columnName + "'s class needs to add the @ContainerAdapter annotation");
        }
        inValue = columnAdapter.toModel(this.getInstance(inValue, columnClass));
        return inValue;
    }

    @Override
    @Nullable
    public DataClass getData() {
        return this.data;
    }

    @Override
    public void setData(DataClass data) {
        this.data = data;
        this.model = null;
    }

    @Override
    public abstract Object getValue(String var1);

    @Override
    public Object getValue(IProperty property) {
        return this.getValue(property.getContainerKey());
    }

    @Override
    public abstract void put(String var1, Object var2);

    @Override
    public void put(IProperty property, Object value) {
        this.put(property.getContainerKey(), value);
    }

    @Override
    public void putDefault(String columnName) {
        Class columnClass = this.modelContainerAdapter.getColumnMap().get(columnName);
        if (columnClass.isPrimitive()) {
            if (columnClass.equals(Boolean.TYPE)) {
                this.put(columnName, (Object)false);
            } else if (columnClass.equals(Character.TYPE)) {
                this.put(columnName, (Object)Character.valueOf('\u0000'));
            } else {
                this.put(columnName, (Object)0);
            }
        } else {
            this.put(columnName, null);
        }
    }

    @Override
    public void putDefault(IProperty property) {
        this.putDefault(property.getContainerKey());
    }

    @Override
    public ModelAdapter<TModel> getModelAdapter() {
        return this.modelAdapter;
    }

    @Override
    public Class<TModel> getTable() {
        return this.modelAdapter.getModelClass();
    }

    @Override
    public void save() {
        this.modelContainerAdapter.save(this);
    }

    @Override
    public void delete() {
        this.modelContainerAdapter.delete(this);
    }

    @Override
    public void update() {
        this.modelContainerAdapter.update(this);
    }

    @Override
    public void insert() {
        this.modelContainerAdapter.insert(this);
    }

    @Override
    public boolean exists() {
        return this.modelContainerAdapter.exists(this);
    }
}

