/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.container;

import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.container.JSONModel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONArrayModel<TModel extends Model>
implements Model {
    private JSONArray jsonArray;
    private Class<TModel> table;

    public JSONArrayModel(JSONArray jsonArray, Class<TModel> table) {
        this.jsonArray = jsonArray;
        this.table = table;
    }

    public JSONArrayModel(Class<TModel> table) {
        this(new JSONArray(), table);
    }

    public void addJSONObject(JSONObject jsonObject) {
        this.jsonArray.put((Object)jsonObject);
    }

    public JSONObject getJSONObject(int index) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this.jsonArray.getJSONObject(index);
        }
        catch (JSONException e) {
            FlowLog.logError(e);
        }
        return jsonObject;
    }

    public TModel getModelObject(int index) {
        return this.getJsonModel(index).toModel();
    }

    public JSONModel<TModel> getJsonModel(int index) {
        return new JSONModel<TModel>(this.getJSONObject(index), this.table);
    }

    public int length() {
        return this.jsonArray != null ? this.jsonArray.length() : 0;
    }

    @Override
    public void save() {
        if (this.jsonArray != null && this.jsonArray.length() > 0) {
            int length = this.jsonArray.length();
            JSONModel<TModel> jsonModel = new JSONModel<TModel>(this.table);
            for (int i = 0; i < length; ++i) {
                try {
                    jsonModel.data = this.jsonArray.getJSONObject(i);
                    jsonModel.save();
                    continue;
                }
                catch (JSONException e) {
                    FlowLog.logError(e);
                }
            }
        }
    }

    @Override
    public void delete() {
        if (this.jsonArray != null && this.jsonArray.length() > 0) {
            int length = this.jsonArray.length();
            JSONModel<TModel> jsonModel = new JSONModel<TModel>(this.table);
            for (int i = 0; i < length; ++i) {
                try {
                    jsonModel.data = this.jsonArray.getJSONObject(i);
                    jsonModel.delete();
                    continue;
                }
                catch (JSONException e) {
                    FlowLog.logError(e);
                }
            }
        }
    }

    @Override
    public void update() {
        if (this.jsonArray != null && this.jsonArray.length() > 0) {
            int length = this.jsonArray.length();
            JSONModel<TModel> jsonModel = new JSONModel<TModel>(this.table);
            for (int i = 0; i < length; ++i) {
                try {
                    jsonModel.data = this.jsonArray.getJSONObject(i);
                    jsonModel.update();
                    continue;
                }
                catch (JSONException e) {
                    FlowLog.logError(e);
                }
            }
        }
    }

    @Override
    public void insert() {
        if (this.jsonArray != null && this.jsonArray.length() > 0) {
            int length = this.jsonArray.length();
            JSONModel<TModel> jsonModel = new JSONModel<TModel>(this.table);
            for (int i = 0; i < length; ++i) {
                try {
                    jsonModel.data = this.jsonArray.getJSONObject(i);
                    jsonModel.insert();
                    continue;
                }
                catch (JSONException e) {
                    FlowLog.logError(e);
                }
            }
        }
    }

    @Override
    public boolean exists() {
        throw new RuntimeException("Cannot call exists() on a JsonArrayModel. Call exists(int) instead");
    }

    public boolean exists(int index) {
        boolean exists = false;
        try {
            exists = new JSONModel<TModel>(this.jsonArray.getJSONObject(index), this.table).exists();
        }
        catch (JSONException e) {
            FlowLog.logError(e);
        }
        return exists;
    }
}

