/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.container;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.data.Blob;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.container.BaseModelContainer;
import com.raizlabs.android.dbflow.structure.container.ModelContainer;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONModel<TModel extends Model>
extends BaseModelContainer<TModel, JSONObject>
implements Model {
    public JSONModel(JSONObject jsonObject, Class<TModel> table) {
        super(table, jsonObject);
    }

    public JSONModel(Class<TModel> table) {
        super(table, new JSONObject());
    }

    public JSONModel(@NonNull ModelContainer<TModel, ?> existingContainer) {
        super(existingContainer);
    }

    @Override
    public BaseModelContainer getInstance(Object inValue, Class<? extends Model> columnClass) {
        if (inValue instanceof ModelContainer) {
            return new JSONModel<TModel>((ModelContainer)inValue);
        }
        return new JSONModel<Model>((JSONObject)inValue, columnClass);
    }

    @Override
    @Nullable
    public Iterator<String> iterator() {
        return this.data != null ? ((JSONObject)this.data).keys() : null;
    }

    @Override
    @NonNull
    public JSONObject newDataInstance() {
        return new JSONObject();
    }

    @Override
    public boolean containsValue(String key) {
        return this.getData() != null && ((JSONObject)this.getData()).has(key) && ((JSONObject)this.getData()).opt(key) != null;
    }

    @Override
    public Object getValue(String key) {
        Object value;
        Object object = value = this.getData() != null ? ((JSONObject)this.getData()).opt(key) : null;
        if (JSONObject.NULL.equals(value)) {
            value = null;
        }
        return value;
    }

    @Override
    public Integer getIntegerValue(String key) {
        try {
            return this.getData() != null ? Integer.valueOf(((JSONObject)this.getData()).getInt(key)) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public int getIntValue(String key) {
        try {
            return this.getData() != null ? ((JSONObject)this.getData()).getInt(key) : 0;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return 0;
        }
    }

    @Override
    public Long getLongValue(String key) {
        try {
            return this.getData() != null ? Long.valueOf(((JSONObject)this.getData()).getLong(key)) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public long getLngValue(String key) {
        try {
            return this.getData() != null ? ((JSONObject)this.getData()).getLong(key) : 0L;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return 0L;
        }
    }

    @Override
    public Boolean getBooleanValue(String key) {
        try {
            return this.getData() != null ? Boolean.valueOf(((JSONObject)this.getData()).getBoolean(key)) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public boolean getBoolValue(String key) {
        try {
            return this.getData() != null && ((JSONObject)this.getData()).getBoolean(key);
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return false;
        }
    }

    @Override
    public String getStringValue(String key) {
        try {
            return this.getData() != null ? ((JSONObject)this.getData()).getString(key) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public Float getFloatValue(String key) {
        Double d = this.getDoubleValue(key);
        return d == null ? null : Float.valueOf(d.floatValue());
    }

    @Override
    public float getFltValue(String key) {
        Float f = this.getFloatValue(key);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public Double getDoubleValue(String key) {
        try {
            return this.getData() != null ? Double.valueOf(((JSONObject)this.getData()).getDouble(key)) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public double getDbleValue(String key) {
        try {
            return this.getData() != null ? ((JSONObject)this.getData()).getDouble(key) : 0.0;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return 0.0;
        }
    }

    @Override
    public Short getShortValue(String key) {
        try {
            return this.getData() != null ? Short.valueOf((short)((JSONObject)this.getData()).getInt(key)) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public short getShrtValue(String key) {
        try {
            return this.getData() != null ? (short)((JSONObject)this.getData()).getInt(key) : (short)0;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return 0;
        }
    }

    @Override
    public Byte[] getBlobValue(String key) {
        try {
            return this.getData() != null ? (Byte[])((JSONObject)this.getData()).get(key) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return null;
        }
    }

    @Override
    public byte[] getBlbValue(String key) {
        try {
            if (this.getData() != null) {
                Object value = ((JSONObject)this.getData()).get(key);
                if (value instanceof Blob) {
                    return ((Blob)value).getBlob();
                }
                return (byte[])value;
            }
        }
        catch (JSONException e) {
            FlowLog.logError(e);
        }
        return null;
    }

    @Override
    public Byte getByteValue(String key) {
        try {
            return this.getData() != null ? Byte.valueOf((byte)((JSONObject)this.getData()).getInt(key)) : null;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return (byte)0;
        }
    }

    @Override
    public byte getBytValue(String key) {
        try {
            return this.getData() != null ? (byte)((JSONObject)this.getData()).getInt(key) : (byte)0;
        }
        catch (JSONException e) {
            FlowLog.logError(e);
            return 0;
        }
    }

    @Override
    public void put(String columnName, Object value) {
        if (this.getData() == null) {
            this.setData(this.newDataInstance());
        }
        try {
            ((JSONObject)this.getData()).put(columnName, value);
        }
        catch (JSONException e) {
            FlowLog.logError(e);
        }
    }
}

