/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.container;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.sql.queriable.ModelContainerLoader;
import com.raizlabs.android.dbflow.sql.saveable.ListModelSaver;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.RetrievalAdapter;
import com.raizlabs.android.dbflow.structure.container.ForeignKeyContainer;
import com.raizlabs.android.dbflow.structure.container.ModelContainer;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelContainerAdapter<TModel extends Model>
extends RetrievalAdapter<ModelContainer<TModel, ?>, TModel>
implements InternalAdapter<ModelContainer<TModel, ?>> {
    private ModelContainerLoader<TModel> modelContainerLoader;
    private ModelSaver<TModel, ModelContainer<TModel, ?>, ModelContainerAdapter<TModel>> modelSaver;
    private ListModelSaver<TModel, ModelContainer<TModel, ?>, ModelContainerAdapter<TModel>> listModelSaver;
    private ModelAdapter<TModel> modelAdapter;
    protected final Map<String, Class> columnMap = new HashMap<String, Class>();

    public ModelContainerAdapter(DatabaseDefinition databaseDefinition) {
        super(databaseDefinition);
        TableConfig tableConfig = this.getTableConfig();
        if (tableConfig != null) {
            if (tableConfig.modelContainerLoader() != null) {
                this.modelContainerLoader = tableConfig.modelContainerLoader();
            }
            if (tableConfig.modelContainerModelSaver() != null) {
                this.modelSaver = tableConfig.modelContainerModelSaver();
                this.modelSaver.setAdapter(this);
                this.modelSaver.setModelAdapter(this.getModelAdapter());
            }
        }
    }

    @Override
    public void save(ModelContainer<TModel, ?> modelContainer) {
        this.getModelSaver().save(modelContainer);
    }

    @Override
    public void save(ModelContainer<TModel, ?> model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().save(model, databaseWrapper);
    }

    @Override
    public void saveAll(Collection<ModelContainer<TModel, ?>> modelContainers) {
        this.getListModelSaver().saveAll(modelContainers);
    }

    @Override
    public void saveAll(Collection<ModelContainer<TModel, ?>> modelContainers, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().saveAll(modelContainers, databaseWrapper);
    }

    @Override
    public void insert(ModelContainer<TModel, ?> modelContainer) {
        this.getModelSaver().insert(modelContainer);
    }

    @Override
    public void insert(ModelContainer<TModel, ?> model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().insert(model, databaseWrapper);
    }

    @Override
    public void insertAll(Collection<ModelContainer<TModel, ?>> modelContainers) {
        this.getListModelSaver().insertAll(modelContainers);
    }

    @Override
    public void insertAll(Collection<ModelContainer<TModel, ?>> modelContainers, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().insertAll(modelContainers, databaseWrapper);
    }

    @Override
    public void update(ModelContainer<TModel, ?> modelContainer) {
        this.getModelSaver().update(modelContainer);
    }

    @Override
    public void update(ModelContainer<TModel, ?> model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().update(model, databaseWrapper);
    }

    @Override
    public void updateAll(Collection<ModelContainer<TModel, ?>> modelContainers) {
        this.getListModelSaver().updateAll(modelContainers);
    }

    @Override
    public void updateAll(Collection<ModelContainer<TModel, ?>> modelContainers, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().updateAll(modelContainers, databaseWrapper);
    }

    @Override
    public void delete(ModelContainer<TModel, ?> modelContainer) {
        this.getModelSaver().delete(modelContainer);
    }

    @Override
    public void delete(ModelContainer<TModel, ?> model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().delete(model, databaseWrapper);
    }

    public ModelSaver<TModel, ModelContainer<TModel, ?>, ModelContainerAdapter<TModel>> getModelSaver() {
        if (this.modelSaver == null) {
            this.modelSaver = new ModelSaver();
            this.modelSaver.setModelAdapter(this.getModelAdapter());
            this.modelSaver.setAdapter(this);
        }
        return this.modelSaver;
    }

    public ListModelSaver<TModel, ModelContainer<TModel, ?>, ModelContainerAdapter<TModel>> getListModelSaver() {
        if (this.listModelSaver == null) {
            this.listModelSaver = new ListModelSaver(this.getModelSaver());
        }
        return this.listModelSaver;
    }

    public ModelAdapter<TModel> getModelAdapter() {
        if (this.modelAdapter == null) {
            this.modelAdapter = FlowManager.getModelAdapter(this.getModelClass());
        }
        return this.modelAdapter;
    }

    public void setModelSaver(ModelSaver<TModel, ModelContainer<TModel, ?>, ModelContainerAdapter<TModel>> modelSaver) {
        this.modelSaver = modelSaver;
    }

    public abstract TModel toModel(ModelContainer<TModel, ?> var1);

    public abstract ForeignKeyContainer<TModel> toForeignKeyContainer(TModel var1);

    @Override
    public void updateAutoIncrement(ModelContainer<TModel, ?> modelContainer, Number id) {
    }

    @Override
    public Number getAutoIncrementingId(ModelContainer<TModel, ?> modelContainer) {
        return 0;
    }

    @Override
    public boolean cachingEnabled() {
        return false;
    }

    @Override
    public void bindToInsertStatement(DatabaseStatement sqLiteStatement, ModelContainer<TModel, ?> model) {
        this.bindToInsertStatement(sqLiteStatement, model, 0);
    }

    @NonNull
    public Map<String, Class> getColumnMap() {
        return this.columnMap;
    }

    public Class<?> getClassForColumn(String columnName) {
        return this.columnMap.get(columnName);
    }

    public ModelContainerLoader<TModel> getModelContainerLoader() {
        if (this.modelContainerLoader == null) {
            this.modelContainerLoader = this.createModelContainerLoader();
        }
        return this.modelContainerLoader;
    }

    protected ModelContainerLoader<TModel> createModelContainerLoader() {
        return new ModelContainerLoader(this.getModelClass());
    }

    public void setModelContainerLoader(ModelContainerLoader<TModel> modelContainerLoader) {
        this.modelContainerLoader = modelContainerLoader;
    }
}

