/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.container;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.container.BaseModelContainer;
import com.raizlabs.android.dbflow.structure.container.ModelContainer;

public abstract class SimpleModelContainer<TModel extends Model, DataClass>
extends BaseModelContainer<TModel, DataClass> {
    public SimpleModelContainer(Class<TModel> table) {
        super(table);
    }

    public SimpleModelContainer(Class<TModel> table, DataClass data) {
        super(table, data);
    }

    public SimpleModelContainer(@NonNull ModelContainer<TModel, ?> existingContainer) {
        super(existingContainer);
    }

    @Override
    public Integer getIntegerValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    @Override
    public int getIntValue(String key) {
        Integer value = this.getIntegerValue(key);
        return value == null ? 0 : value;
    }

    @Override
    public Long getLongValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    @Override
    public long getLngValue(String key) {
        Long value = this.getLongValue(key);
        return value == null ? 0L : value;
    }

    @Override
    public Boolean getBooleanValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue() == 1;
        }
        return null;
    }

    @Override
    public boolean getBoolValue(String key) {
        Boolean value = this.getBooleanValue(key);
        return value != null && value != false;
    }

    @Override
    public String getStringValue(String key) {
        return String.valueOf(this.getValue(key));
    }

    @Override
    public Float getFloatValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Float.valueOf((String)value);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return null;
    }

    @Override
    public float getFltValue(String key) {
        Float value = this.getFloatValue(key);
        return value == null ? 0.0f : value.floatValue();
    }

    @Override
    public Double getDoubleValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    @Override
    public double getDbleValue(String key) {
        Double value = this.getDoubleValue(key);
        return value == null ? 0.0 : value;
    }

    @Override
    public Byte[] getBlobValue(String key) {
        return (Byte[])this.getValue(key);
    }

    @Override
    public byte[] getBlbValue(String key) {
        return (byte[])this.getValue(key);
    }

    @Override
    public Short getShortValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return null;
    }

    @Override
    public short getShrtValue(String key) {
        Short value = this.getShortValue(key);
        return value == null ? (short)0 : value;
    }

    @Override
    public Byte getByteValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return null;
    }

    @Override
    public byte getBytValue(String key) {
        Byte value = this.getByteValue(key);
        return value == null ? (byte)0 : value;
    }
}

