/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.language.CursorResult;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.List;

public class QueryTransaction<TResult extends Model>
implements ITransaction {
    final ModelQueriable<TResult> modelQueriable;
    final QueryResultCallback<TResult> queryResultCallback;
    final QueryResultListCallback<TResult> queryResultListCallback;
    final QueryResultSingleCallback<TResult> queryResultSingleCallback;
    final boolean runResultCallbacksOnSameThread;

    QueryTransaction(Builder<TResult> builder) {
        this.modelQueriable = builder.modelQueriable;
        this.queryResultCallback = builder.queryResultCallback;
        this.queryResultListCallback = builder.queryResultListCallback;
        this.queryResultSingleCallback = builder.queryResultSingleCallback;
        this.runResultCallbacksOnSameThread = builder.runResultCallbacksOnSameThread;
    }

    @Override
    public void execute(DatabaseWrapper databaseWrapper) {
        final CursorResult<TResult> cursorResult = this.modelQueriable.queryResults();
        if (this.queryResultCallback != null) {
            if (this.runResultCallbacksOnSameThread) {
                this.queryResultCallback.onQueryResult(this, cursorResult);
            } else {
                Transaction.getTransactionHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        QueryTransaction.this.queryResultCallback.onQueryResult(QueryTransaction.this, cursorResult);
                    }
                });
            }
        }
        if (this.queryResultListCallback != null) {
            final List<TResult> resultList = cursorResult.toListClose();
            if (this.runResultCallbacksOnSameThread) {
                this.queryResultListCallback.onListQueryResult(this, resultList);
            } else {
                Transaction.getTransactionHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        QueryTransaction.this.queryResultListCallback.onListQueryResult(QueryTransaction.this, resultList);
                    }
                });
            }
        }
        if (this.queryResultSingleCallback != null) {
            TResult result = cursorResult.toModelClose();
            if (this.runResultCallbacksOnSameThread) {
                this.queryResultSingleCallback.onSingleQueryResult(this, result);
            } else {
                Transaction.getTransactionHandler().post(new Runnable((Model)result){
                    final /* synthetic */ Model val$result;
                    {
                        this.val$result = model;
                    }

                    @Override
                    public void run() {
                        QueryTransaction.this.queryResultSingleCallback.onSingleQueryResult(QueryTransaction.this, this.val$result);
                    }
                });
            }
        }
    }

    public static final class Builder<TResult extends Model> {
        final ModelQueriable<TResult> modelQueriable;
        QueryResultCallback<TResult> queryResultCallback;
        QueryResultListCallback<TResult> queryResultListCallback;
        QueryResultSingleCallback<TResult> queryResultSingleCallback;
        boolean runResultCallbacksOnSameThread;

        public Builder(@NonNull ModelQueriable<TResult> modelQueriable) {
            this.modelQueriable = modelQueriable;
        }

        public Builder<TResult> queryResult(QueryResultCallback<TResult> queryResultCallback) {
            this.queryResultCallback = queryResultCallback;
            return this;
        }

        public Builder<TResult> queryListResult(QueryResultListCallback<TResult> queryResultListCallback) {
            this.queryResultListCallback = queryResultListCallback;
            return this;
        }

        public Builder<TResult> querySingleResult(QueryResultSingleCallback<TResult> queryResultSingleCallback) {
            this.queryResultSingleCallback = queryResultSingleCallback;
            return this;
        }

        public Builder<TResult> runResultCallbacksOnSameThread(boolean runResultCallbacksOnSameThread) {
            this.runResultCallbacksOnSameThread = runResultCallbacksOnSameThread;
            return this;
        }

        public QueryTransaction<TResult> build() {
            return new QueryTransaction(this);
        }
    }

    public static interface QueryResultSingleCallback<TResult extends Model> {
        public void onSingleQueryResult(QueryTransaction var1, @Nullable TResult var2);
    }

    public static interface QueryResultListCallback<TResult extends Model> {
        public void onListQueryResult(QueryTransaction var1, @Nullable List<TResult> var2);
    }

    public static interface QueryResultCallback<TResult extends Model> {
        public void onQueryResult(QueryTransaction var1, @NonNull CursorResult<TResult> var2);
    }
}

