/*
 * Decompiled with CFR 0.152.
 */
package com.caveman.listcheckbox.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.caveman.listcheckbox.R;
import com.caveman.listcheckbox.adapter.TreeListViewAdapter;
import com.caveman.listcheckbox.bean.Node;
import com.caveman.listcheckbox.listener.OnTreeNodeCheckedChangeListener;
import com.caveman.listcheckbox.utils.ListUtils;
import java.util.List;

public class ListViewAdapter<T>
extends TreeListViewAdapter {
    private OnTreeNodeCheckedChangeListener checkedChangeListener;
    private int layoutItem = R.layout.item_list;

    public void setCheckedChangeListener(OnTreeNodeCheckedChangeListener checkedChangeListener) {
        this.checkedChangeListener = checkedChangeListener;
    }

    public ListViewAdapter(ListView listView, Context context, List<T> datas, int defaultExpandLevel) {
        super(listView, context, ListUtils.getInstance().toListObject(datas), defaultExpandLevel);
    }

    public ListViewAdapter(ListView listView, Context context, List<T> datas, int defaultExpandLevel, int iconExpand, int iconNoExpand) {
        super(listView, context, ListUtils.getInstance().toListObject(datas), defaultExpandLevel, iconExpand, iconNoExpand);
    }

    public ListViewAdapter(ListView listView, Context context, List<T> datas, int defaultExpandLevel, int layoutItem, int iconExpand, int iconNoExpand) {
        super(listView, context, ListUtils.getInstance().toListObject(datas), defaultExpandLevel, iconExpand, iconNoExpand);
        this.layoutItem = layoutItem;
    }

    @Override
    public View getConvertView(final Node node, final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)this.layoutItem, null);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.tvName.setText((CharSequence)node.getName());
        if (node.getIcon() == -1) {
            holder.ivExpand.setVisibility(4);
        } else {
            holder.ivExpand.setVisibility(0);
            holder.ivExpand.setImageResource(node.getIcon());
        }
        holder.checkBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ListViewAdapter.this.setChecked(node, holder.checkBox.isChecked());
                if (ListViewAdapter.this.checkedChangeListener != null) {
                    ListViewAdapter.this.checkedChangeListener.onCheckChange(node.getId(), node.getName(), position, holder.checkBox.isChecked());
                }
            }
        });
        if (this.layoutItem == R.layout.item_list) {
            if (this.singleCheck) {
                holder.checkBox.setButtonDrawable(R.drawable.radiobox_style);
            } else {
                holder.checkBox.setButtonDrawable(R.drawable.checkbox_style);
            }
        }
        if (this.singleCheck) {
            if (node.getChildren().size() != 0) {
                holder.checkBox.setEnabled(false);
            } else {
                holder.checkBox.setEnabled(true);
            }
        }
        if (node.isChecked()) {
            holder.checkBox.setChecked(true);
        } else {
            holder.checkBox.setChecked(false);
        }
        return convertView;
    }

    static class ViewHolder {
        private CheckBox checkBox;
        private TextView tvName;
        private ImageView ivExpand;

        public ViewHolder(View convertView) {
            this.checkBox = (CheckBox)convertView.findViewById(R.id.cb);
            this.tvName = (TextView)convertView.findViewById(R.id.tv_name);
            this.ivExpand = (ImageView)convertView.findViewById(R.id.iv_expand);
        }
    }
}

