/*
 * Decompiled with CFR 0.152.
 */
package com.caveman.listcheckbox.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.caveman.listcheckbox.R;
import com.caveman.listcheckbox.bean.Node;
import com.caveman.listcheckbox.helper.TreeHelper;
import com.caveman.listcheckbox.listener.OnTreeNodeClickListener;
import com.caveman.listcheckbox.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class TreeListViewAdapter<T>
extends BaseAdapter {
    protected Context mContext;
    private int defaultExpandLevel = 0;
    private int iconExpand = -1;
    private int iconNoExpand = -1;
    protected List<Node> mAllNodes = new ArrayList<Node>();
    protected LayoutInflater mInflater;
    protected boolean singleCheck = false;
    protected List<Node> mNodes = new ArrayList<Node>();
    private OnTreeNodeClickListener onTreeNodeClickListener;

    public void setOnTreeNodeClickListener(OnTreeNodeClickListener onTreeNodeClickListener) {
        this.onTreeNodeClickListener = onTreeNodeClickListener;
    }

    public TreeListViewAdapter(ListView listView, Context context, List<Node> datas, int defaultExpandLevel, int iconExpand, int iconNoExpand) {
        this.mContext = context;
        this.defaultExpandLevel = defaultExpandLevel;
        this.iconExpand = iconExpand;
        this.iconNoExpand = iconNoExpand;
        for (Node node : datas) {
            node.getChildren().clear();
            node.setIconExpand(iconExpand);
            node.setIconNoExpand(iconNoExpand);
        }
        this.mAllNodes = TreeHelper.getSortedNodes(datas, defaultExpandLevel);
        this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
        this.mInflater = LayoutInflater.from((Context)context);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                TreeListViewAdapter.this.expandOrCollapse(position);
                if (TreeListViewAdapter.this.onTreeNodeClickListener != null) {
                    TreeListViewAdapter.this.onTreeNodeClickListener.onClick(TreeListViewAdapter.this.mNodes.get(position), position);
                }
            }
        });
    }

    public TreeListViewAdapter(ListView listView, Context context, List<Node> datas, int defaultExpandLevel) {
        this(listView, context, datas, defaultExpandLevel, R.drawable.zoomin_yzs, R.drawable.zoomout_yzs);
    }

    public void expandOrCollapse(int position) {
        Node n = this.mNodes.get(position);
        if (n != null && !n.isLeaf()) {
            n.setExpand(!n.isExpand());
            this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mNodes.size();
    }

    public Object getItem(int position) {
        return this.mNodes.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Node node = this.mNodes.get(position);
        convertView = this.getConvertView(node, position, convertView, parent);
        convertView.setPadding(node.getLevel() * 50, 12, 12, 12);
        return convertView;
    }

    public List<Node> getAllNodes() {
        if (this.mAllNodes == null) {
            this.mAllNodes = new ArrayList<Node>();
        }
        return this.mAllNodes;
    }

    public List<Node> getSelectedNode() {
        ArrayList<Node> checks = new ArrayList<Node>();
        if (this.singleCheck) {
            checks.addAll(this.getSelectedChildNode());
        } else {
            for (Node n : this.mAllNodes) {
                if (!n.isChecked()) continue;
                checks.add(n);
            }
        }
        return checks;
    }

    public List<Node> getSelectedChildNode() {
        ArrayList<Node> checks = new ArrayList<Node>();
        for (Node n : this.mAllNodes) {
            if (!n.isChecked() || n.getChildren().size() != 0) continue;
            checks.add(n);
        }
        return checks;
    }

    public void setSingleCheck(boolean singleCheck) {
        this.singleCheck = singleCheck;
    }

    protected void setChecked(Node node, boolean checked) {
        if (this.singleCheck) {
            for (Node n : this.mAllNodes) {
                if (!n.isChecked()) continue;
                n.setChecked(false);
            }
            node.setChecked(checked);
        } else {
            node.setChecked(checked);
            this.setChildChecked(node, checked);
        }
        if (node.getParent() != null) {
            this.setNodeParentChecked(node.getParent(), checked);
        }
        this.notifyDataSetChanged();
    }

    public <T> void setChildChecked(Node<T> node, boolean checked) {
        if (!node.isLeaf()) {
            node.setChecked(checked);
            for (Node childrenNode : node.getChildren()) {
                this.setChildChecked(childrenNode, checked);
            }
        } else {
            node.setChecked(checked);
        }
    }

    private void setNodeParentChecked(Node node, boolean checked) {
        if (checked) {
            node.setChecked(checked);
            if (node.getParent() != null) {
                this.setNodeParentChecked(node.getParent(), checked);
            }
        } else {
            List<Node> childrens = node.getChildren();
            boolean isChecked = false;
            for (Node children : childrens) {
                if (!children.isChecked()) continue;
                isChecked = true;
            }
            if (!isChecked) {
                node.setChecked(checked);
            }
            if (node.getParent() != null) {
                this.setNodeParentChecked(node.getParent(), checked);
            }
        }
    }

    public void addDataAll(List<T> mlists, int defaultExpandLevel) {
        this.mAllNodes.clear();
        this.addData(-1, ListUtils.getInstance().toListObject(mlists), defaultExpandLevel);
    }

    public void addData(int index, List<T> mlists, int defaultExpandLevel) {
        this.defaultExpandLevel = defaultExpandLevel;
        this.notifyData(index, ListUtils.getInstance().toListObject(mlists));
    }

    public void addData(int index, List<T> mlists) {
        this.notifyData(index, ListUtils.getInstance().toListObject(mlists));
    }

    public void addData(List<T> mlists) {
        this.addData((T)ListUtils.getInstance().toListObject(mlists), this.defaultExpandLevel);
    }

    public void addData(List<T> mlists, int defaultExpandLevel) {
        this.defaultExpandLevel = defaultExpandLevel;
        this.notifyData(-1, mlists);
    }

    public void addData(T t) {
        this.addData(t, this.defaultExpandLevel);
    }

    public void addData(T node, int defaultExpandLevel) {
        ArrayList<T> nodes = new ArrayList<T>();
        nodes.add(node);
        this.defaultExpandLevel = defaultExpandLevel;
        this.notifyData(-1, nodes);
    }

    public void notifyData(int index, List<T> mListNodes) {
        Node node;
        int i;
        List<T> nodes = mListNodes;
        for (i = 0; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            node.getChildren().clear();
            node.iconExpand = this.iconExpand;
            node.iconNoExpand = this.iconNoExpand;
        }
        for (i = 0; i < this.mAllNodes.size(); ++i) {
            node = this.mAllNodes.get(i);
            node.getChildren().clear();
        }
        if (index != -1) {
            this.mAllNodes.addAll(index, nodes);
        } else {
            this.mAllNodes.addAll(nodes);
        }
        this.mAllNodes = TreeHelper.getSortedNodes(this.mAllNodes, this.defaultExpandLevel);
        this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
        this.notifyDataSetChanged();
    }

    public abstract View getConvertView(Node var1, int var2, View var3, ViewGroup var4);
}

