/*
 * Decompiled with CFR 0.152.
 */
package com.caveman.listcheckbox.bean;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;

public class Node<T> {
    private String id;
    private String pid;
    private T data;
    public int iconExpand = -1;
    public int iconNoExpand = -1;
    private String name;
    private int level;
    private boolean isExpand = false;
    private int icon = -1;
    private List<Node> children = new ArrayList<Node>();
    private Node parent;
    Gson gson = new Gson();
    private boolean isChecked;

    public Node() {
    }

    public Node(String id2, String pid, String name) {
        this.id = id2;
        this.pid = pid;
        this.name = name;
    }

    public Node(T t) {
        String str = this.gson.toJson(t);
        Node node = (Node)this.gson.fromJson(str, Node.class);
        this.name = node.toString();
        this.id = node.id;
        this.pid = node.pid;
        this.data = t;
    }

    public Node(String json) {
        Node node = (Node)this.gson.fromJson(json, Node.class);
        this.name = node.toString();
        this.id = node.id;
        this.pid = node.pid;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public boolean isParentExpand() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isExpand();
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public void setExpand(boolean isExpand) {
        this.isExpand = isExpand;
        if (!isExpand) {
            for (Node node : this.children) {
                node.setExpand(isExpand);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getIconExpand() {
        return this.iconExpand;
    }

    public void setIconExpand(int iconExpand) {
        this.iconExpand = iconExpand;
    }

    public int getIconNoExpand() {
        return this.iconNoExpand;
    }

    public void setIconNoExpand(int iconNoExpand) {
        this.iconNoExpand = iconNoExpand;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(int icon) {
        this.icon = icon;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public void setChildren(List<Node> children) {
        this.children = children;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }
}

