/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib;

import android.content.Context;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import com.zlylib.fileselectorlib.FileSelector;
import com.zlylib.fileselectorlib.SelectOptions;
import com.zlylib.fileselectorlib.ui.FileSelectorActivity;

public final class SelectCreator {
    private FileSelector filePicker;
    private SelectOptions selectOptions = SelectOptions.getCleanInstance();

    public SelectCreator(FileSelector filePicker) {
        this.filePicker = filePicker;
    }

    public SelectCreator setMaxCount(int maxCount) {
        this.selectOptions.maxCount = maxCount;
        if (maxCount <= 1) {
            this.selectOptions.maxCount = 1;
            this.selectOptions.isSingle = true;
        } else {
            this.selectOptions.isSingle = false;
        }
        return this;
    }

    public SelectCreator setTargetPath(String path) {
        this.selectOptions.targetPath = path;
        return this;
    }

    public SelectCreator setFileTypes(String ... fileTypes) {
        this.selectOptions.mFileTypes = fileTypes;
        return this;
    }

    public SelectCreator setSortType(int sortType) {
        this.selectOptions.setSortType(sortType);
        return this;
    }

    public SelectCreator isSingle() {
        this.selectOptions.isSingle = true;
        this.selectOptions.maxCount = 1;
        return this;
    }

    public SelectCreator onlyShowFolder() {
        this.selectOptions.setOnlyShowFolder(true);
        this.selectOptions.setOnlySelectFolder(true);
        return this;
    }

    public SelectCreator onlySelectFolder() {
        this.selectOptions.setOnlySelectFolder(true);
        return this;
    }

    public SelectCreator setTilteBg(int color) {
        this.selectOptions.setTitleBg(color);
        return this;
    }

    public SelectCreator setTitleColor(int color) {
        this.selectOptions.setTitleColor(color);
        return this;
    }

    public SelectCreator setTitleLiftColor(int color) {
        this.selectOptions.setTitleLiftColor(color);
        return this;
    }

    public SelectCreator setTitleRightColor(int color) {
        this.selectOptions.setTitleRightColor(color);
        return this;
    }

    public SelectCreator requestCode(int requestCode) {
        this.selectOptions.request_code = requestCode;
        return this;
    }

    public void start() {
        Context activity = this.filePicker.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setClass(activity, FileSelectorActivity.class);
        Fragment fragment = this.filePicker.getFragment();
        if (fragment != null) {
            fragment.startActivityForResult(intent, this.selectOptions.request_code);
        } else {
            ((AppCompatActivity)activity).startActivityForResult(intent, this.selectOptions.request_code);
        }
    }
}

