/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib;

import android.os.Environment;
import android.text.TextUtils;
import java.io.File;

public class SelectOptions {
    public static final String defaultTargetPath = Environment.getExternalStorageDirectory() + "/";
    public String[] mFileTypes;
    public String mSortType;
    public boolean isSingle = false;
    public int maxCount = 10;
    private boolean onlyShowFolder = false;
    private boolean onlySelectFolder = false;
    public int request_code;
    public String targetPath = defaultTargetPath;
    private int titleBg = 0;
    private int titleColor = 0;
    private int titleLiftColor = 0;
    private int titleRightColor = 0;

    public String[] getFileTypes() {
        if (this.mFileTypes == null || this.mFileTypes.length == 0) {
            return new String[0];
        }
        return this.mFileTypes;
    }

    public int getSortType() {
        if (TextUtils.isEmpty((CharSequence)this.mSortType)) {
            return 0;
        }
        return Integer.valueOf(this.mSortType);
    }

    public void setSortType(int sortType) {
        this.mSortType = String.valueOf(sortType);
    }

    public String getTargetPath() {
        if (!new File(this.targetPath).exists()) {
            File file = new File(defaultTargetPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            return defaultTargetPath;
        }
        return this.targetPath;
    }

    public boolean isOnlyShowFolder() {
        return this.onlyShowFolder;
    }

    public void setOnlyShowFolder(boolean onlyShowFolder) {
        this.onlyShowFolder = onlyShowFolder;
    }

    public boolean isOnlySelectFolder() {
        return this.onlySelectFolder;
    }

    public void setOnlySelectFolder(boolean onlySelectFolder) {
        this.onlySelectFolder = onlySelectFolder;
    }

    public int getTitleBg() {
        return this.titleBg;
    }

    public void setTitleBg(int titleBg) {
        this.titleBg = titleBg;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    public int getTitleLiftColor() {
        return this.titleLiftColor;
    }

    public void setTitleLiftColor(int titleLiftColor) {
        this.titleLiftColor = titleLiftColor;
    }

    public int getTitleRightColor() {
        return this.titleRightColor;
    }

    public void setTitleRightColor(int titleRightColor) {
        this.titleRightColor = titleRightColor;
    }

    public static SelectOptions getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static SelectOptions getCleanInstance() {
        SelectOptions options = SelectOptions.getInstance();
        options.reset();
        return options;
    }

    private void reset() {
        this.mFileTypes = new String[0];
        this.mSortType = String.valueOf(0);
        this.isSingle = false;
        this.maxCount = 10;
        this.onlyShowFolder = false;
        this.onlySelectFolder = false;
        this.targetPath = defaultTargetPath;
        this.titleBg = 0;
        this.titleColor = 0;
        this.titleLiftColor = 0;
        this.titleRightColor = 0;
    }

    private static final class InstanceHolder {
        private static final SelectOptions INSTANCE = new SelectOptions();

        private InstanceHolder() {
        }
    }
}

