/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib.bean;

import android.content.ContentUris;
import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.zlylib.fileselectorlib.utils.FileUtils;
import com.zlylib.fileselectorlib.utils.MimeType;
import com.zlylib.fileselectorlib.utils.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class EssFile
implements Parcelable {
    public static final int CAPTURE = 0;
    public static final int MEDIA = 1;
    private String mFilePath;
    private String mimeType;
    private String childFolderCount = "\u52a0\u8f7d\u4e2d";
    private String childFileCount = "\u52a0\u8f7d\u4e2d";
    private boolean isChecked = false;
    private boolean isExits = false;
    private boolean isDirectory = false;
    private boolean isFile = false;
    private String mFileName;
    private Uri uri;
    private int itemType = 1;
    public static final Parcelable.Creator<EssFile> CREATOR = new Parcelable.Creator<EssFile>(){

        public EssFile createFromParcel(Parcel in) {
            return new EssFile(in);
        }

        public EssFile[] newArray(int size) {
            return new EssFile[size];
        }
    };

    protected EssFile(Parcel in) {
        this.mFilePath = in.readString();
        this.mimeType = in.readString();
        this.childFolderCount = in.readString();
        this.childFileCount = in.readString();
        this.isChecked = in.readByte() != 0;
        this.isExits = in.readByte() != 0;
        this.isDirectory = in.readByte() != 0;
        this.isFile = in.readByte() != 0;
        this.mFileName = in.readString();
        this.uri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.itemType = in.readInt();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    public EssFile(String path) {
        this.mFilePath = path;
        File file = new File(this.mFilePath);
        if (file.exists()) {
            this.isExits = true;
            this.isDirectory = file.isDirectory();
            this.isFile = file.isFile();
            this.mFileName = file.getName();
        }
        this.mimeType = FileUtils.getMimeType(this.mFilePath);
    }

    public EssFile(File file) {
        this.mFilePath = file.getAbsolutePath();
        if (file.exists()) {
            this.isExits = true;
            this.isDirectory = file.isDirectory();
            this.isFile = file.isFile();
        }
        this.mimeType = FileUtils.getMimeType(file.getAbsolutePath());
    }

    public EssFile(long id2, String mimeType) {
        this.mimeType = mimeType;
        Uri contentUri = this.isImage() ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (this.isVideo() ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Files.getContentUri((String)"external"));
        this.uri = ContentUris.withAppendedId((Uri)contentUri, (long)id2);
    }

    public Uri getUri() {
        return this.uri;
    }

    public boolean isExits() {
        return this.isExits;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getChildFolderCount() {
        return this.childFolderCount;
    }

    public void setChildFolderCount(String childFolderCount) {
        this.childFolderCount = childFolderCount;
    }

    public String getChildFileCount() {
        return this.childFileCount;
    }

    public void setChildFileCount(String childFileCount) {
        this.childFileCount = childFileCount;
    }

    public void setChildCounts(String childFileCount, String childFolderCount) {
        this.childFileCount = childFileCount;
        this.childFolderCount = childFolderCount;
    }

    public File getFile() {
        return new File(this.mFilePath);
    }

    public String getName() {
        return new File(this.mFilePath).getName();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getAbsolutePath() {
        return this.mFilePath;
    }

    public static List<EssFile> getEssFileList(List<File> files, boolean isSelectFolder) {
        ArrayList<EssFile> essFileList = new ArrayList<EssFile>();
        for (File file : files) {
            if (isSelectFolder) {
                if (!EssFile.isFolder(file)) continue;
                essFileList.add(new EssFile(file));
                continue;
            }
            essFileList.add(new EssFile(file));
        }
        return essFileList;
    }

    public static ArrayList<EssFile> getEssFileList(Context context, Set<EssFile> essFileSet) {
        ArrayList<EssFile> essFileArrayList = new ArrayList<EssFile>();
        for (EssFile ess_file : essFileSet) {
            ess_file.mFilePath = PathUtils.getPath(context, ess_file.uri);
            essFileArrayList.add(ess_file);
        }
        return essFileArrayList;
    }

    public static ArrayList<String> getFilePathList(ArrayList<EssFile> essFileArrayList) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (EssFile essFile : essFileArrayList) {
            resultList.add(essFile.getAbsolutePath());
        }
        return resultList;
    }

    public String toString() {
        return "EssFile{mFilePath='" + this.mFilePath + '\'' + ", mimeType='" + this.mimeType + '\'' + ", mFileName='" + this.mFileName + '\'' + '}';
    }

    public static boolean isFolder(File file) {
        return file.isDirectory();
    }

    public boolean isImage() {
        if (this.mimeType == null) {
            return false;
        }
        return this.mimeType.equals(MimeType.JPEG.toString()) || this.mimeType.equals(MimeType.PNG.toString()) || this.mimeType.equals(MimeType.GIF.toString()) || this.mimeType.equals(MimeType.BMP.toString()) || this.mimeType.equals(MimeType.WEBP.toString());
    }

    public boolean isGif() {
        if (this.mimeType == null) {
            return false;
        }
        return this.mimeType.equals(MimeType.GIF.toString());
    }

    public boolean isVideo() {
        if (this.mimeType == null) {
            return false;
        }
        return this.mimeType.equals(MimeType.MPEG.toString()) || this.mimeType.equals(MimeType.MP4.toString()) || this.mimeType.equals(MimeType.QUICKTIME.toString()) || this.mimeType.equals(MimeType.THREEGPP.toString()) || this.mimeType.equals(MimeType.THREEGPP2.toString()) || this.mimeType.equals(MimeType.MKV.toString()) || this.mimeType.equals(MimeType.WEBM.toString()) || this.mimeType.equals(MimeType.TS.toString()) || this.mimeType.equals(MimeType.AVI.toString());
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    public int getItemType() {
        return this.itemType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFilePath);
        dest.writeString(this.mimeType);
        dest.writeString(this.childFolderCount);
        dest.writeString(this.childFileCount);
        dest.writeByte((byte)(this.isChecked ? 1 : 0));
        dest.writeByte((byte)(this.isExits ? 1 : 0));
        dest.writeByte((byte)(this.isDirectory ? 1 : 0));
        dest.writeByte((byte)(this.isFile ? 1 : 0));
        dest.writeString(this.mFileName);
        dest.writeParcelable((Parcelable)this.uri, flags);
        dest.writeInt(this.itemType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EssFile)) {
            return false;
        }
        EssFile other = (EssFile)obj;
        if (this.uri == null) {
            return this.mFilePath.equalsIgnoreCase(other.getAbsolutePath());
        }
        return this.uri.equals((Object)other.getUri());
    }

    public int hashCode() {
        int result = this.mFilePath != null ? this.mFilePath.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + this.itemType;
        return result;
    }
}

