/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib.core;

import android.os.AsyncTask;
import com.zlylib.fileselectorlib.bean.EssFile;
import com.zlylib.fileselectorlib.bean.EssFileCountCallBack;
import com.zlylib.fileselectorlib.bean.EssFileFilter;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class EssFileCountTask
extends AsyncTask<Void, Void, Void> {
    private int position;
    private String queryPath;
    private String[] types;
    private EssFileCountCallBack countCallBack;
    private int childFileCount = 0;
    private int childFolderCount = 0;
    private Boolean isSelectFolder = false;

    public EssFileCountTask(int position, String queryPath, String[] types, Boolean isSelectFolder, EssFileCountCallBack countCallBack) {
        this.position = position;
        this.queryPath = queryPath;
        this.types = types;
        this.isSelectFolder = isSelectFolder;
        this.countCallBack = countCallBack;
    }

    protected Void doInBackground(Void ... voids) {
        File file = new File(this.queryPath);
        File[] files = file.listFiles(new EssFileFilter(this.types));
        if (files == null) {
            return null;
        }
        List<EssFile> fileList = EssFile.getEssFileList(Arrays.asList(files), this.isSelectFolder);
        for (EssFile essFile : fileList) {
            if (essFile.isDirectory()) {
                ++this.childFolderCount;
                continue;
            }
            ++this.childFileCount;
        }
        return null;
    }

    protected void onPostExecute(Void aVoid) {
        if (this.countCallBack != null) {
            this.countCallBack.onFindChildFileAndFolderCount(this.position, String.valueOf(this.childFileCount), String.valueOf(this.childFolderCount));
        }
    }
}

