/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib.core;

import android.os.AsyncTask;
import com.zlylib.fileselectorlib.bean.EssFile;
import com.zlylib.fileselectorlib.bean.EssFileFilter;
import com.zlylib.fileselectorlib.bean.EssFileListCallBack;
import com.zlylib.fileselectorlib.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EssFileListTask
extends AsyncTask<Void, Void, List<EssFile>> {
    private List<EssFile> mSelectedFileList;
    private String queryPath;
    private String[] types;
    private int mSortType;
    private EssFileListCallBack callBack;
    private Boolean isSelectFolder = false;

    public EssFileListTask(List<EssFile> mSelectedFileList, String queryPath, String[] types, int mSortType, Boolean isSelectFolder, EssFileListCallBack fileCallBack) {
        this.mSelectedFileList = mSelectedFileList;
        this.queryPath = queryPath;
        this.types = types;
        this.mSortType = mSortType;
        this.isSelectFolder = isSelectFolder;
        this.callBack = fileCallBack;
    }

    protected List<EssFile> doInBackground(Void ... voids) {
        File file = new File(this.queryPath);
        File[] files = file.listFiles(new EssFileFilter(this.types));
        if (files == null) {
            return new ArrayList<EssFile>();
        }
        List<File> fileList = Arrays.asList(files);
        if (this.mSortType == 0) {
            Collections.sort(fileList, new FileUtils.SortByName());
        } else if (this.mSortType == 1) {
            Collections.sort(fileList, new FileUtils.SortByName());
            Collections.reverse(fileList);
        } else if (this.mSortType == 2) {
            Collections.sort(fileList, new FileUtils.SortByTime());
        } else if (this.mSortType == 3) {
            Collections.sort(fileList, new FileUtils.SortByTime());
            Collections.reverse(fileList);
        } else if (this.mSortType == 4) {
            Collections.sort(fileList, new FileUtils.SortBySize());
        } else if (this.mSortType == 5) {
            Collections.sort(fileList, new FileUtils.SortBySize());
            Collections.reverse(fileList);
        } else if (this.mSortType == 6) {
            Collections.sort(fileList, new FileUtils.SortByExtension());
        } else if (this.mSortType == 7) {
            Collections.sort(fileList, new FileUtils.SortByExtension());
            Collections.reverse(fileList);
        }
        List<EssFile> tempFileList = EssFile.getEssFileList(fileList, this.isSelectFolder);
        block0: for (EssFile selectedFile : this.mSelectedFileList) {
            for (int i = 0; i < tempFileList.size(); ++i) {
                if (!selectedFile.getAbsolutePath().equals(tempFileList.get(i).getAbsolutePath())) continue;
                tempFileList.get(i).setChecked(true);
                continue block0;
            }
        }
        return tempFileList;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected void onPostExecute(List<EssFile> essFileList) {
        if (this.callBack != null) {
            this.callBack.onFindFileList(this.queryPath, essFileList);
        }
    }
}

