/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemChildClickListener;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.google.android.material.snackbar.Snackbar;
import com.zlylib.fileselectorlib.R;
import com.zlylib.fileselectorlib.SelectOptions;
import com.zlylib.fileselectorlib.adapter.BreadAdapter;
import com.zlylib.fileselectorlib.adapter.FileListAdapter;
import com.zlylib.fileselectorlib.adapter.SelectSdcardAdapter;
import com.zlylib.fileselectorlib.bean.BreadModel;
import com.zlylib.fileselectorlib.bean.EssFile;
import com.zlylib.fileselectorlib.bean.EssFileCountCallBack;
import com.zlylib.fileselectorlib.bean.EssFileListCallBack;
import com.zlylib.fileselectorlib.core.EssFileCountTask;
import com.zlylib.fileselectorlib.core.EssFileListTask;
import com.zlylib.fileselectorlib.utils.FileUtils;
import com.zlylib.titlebarlib.ActionBarCommon;
import com.zlylib.titlebarlib.OnActionBarChildClickListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileSelectorActivity
extends AppCompatActivity
implements OnItemClickListener,
OnItemChildClickListener,
View.OnClickListener,
FileListAdapter.onLoadFileCountListener,
EssFileListCallBack,
EssFileCountCallBack {
    private String mCurFolder = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    private boolean mHasChangeSdCard = false;
    private List<String> mSdCardList;
    private ActionBarCommon abc;
    private RecyclerView mRecyclerView;
    private RecyclerView mBreadRecyclerView;
    private ImageView mImbSelectSdCard;
    private ArrayList<EssFile> mSelectedFileList = new ArrayList();
    private ArrayList<String> mSelectedList = new ArrayList();
    private int mSelectSortTypeIndex = 0;
    private BreadAdapter mBreadAdapter;
    private FileListAdapter mAdapter;
    private EssFileListTask essFileListTask;
    private EssFileCountTask essFileCountTask;
    private PopupWindow mSelectSdCardWindow;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_select_file);
        this.mSdCardList = FileUtils.getAllSdPaths((Context)this);
        if (!this.mSdCardList.isEmpty()) {
            this.mCurFolder = this.mSdCardList.get(0) + File.separator;
            if (FileUtils.exist(SelectOptions.getInstance().getTargetPath())) {
                this.mCurFolder = SelectOptions.getInstance().getTargetPath();
            }
        }
        this.initUi();
        this.initData();
    }

    @SuppressLint(value={"ResourceAsColor"})
    private void initUi() {
        this.abc = (ActionBarCommon)this.findViewById(R.id.abc);
        if (SelectOptions.getInstance().getTitleBg() != 0) {
            this.abc.setBackgroundColor(this.getResources().getColor(SelectOptions.getInstance().getTitleBg()));
        }
        if (SelectOptions.getInstance().getTitleColor() != 0) {
            this.abc.getTitleTextView().setTextColor(this.getResources().getColor(SelectOptions.getInstance().getTitleColor()));
        }
        if (SelectOptions.getInstance().getTitleLiftColor() != 0) {
            this.abc.getLeftIconView().setColorFilter(this.getResources().getColor(SelectOptions.getInstance().getTitleLiftColor()));
        }
        if (SelectOptions.getInstance().getTitleRightColor() != 0) {
            this.abc.getRightTextView().setTextColor(this.getResources().getColor(SelectOptions.getInstance().getTitleRightColor()));
        }
        this.abc.setOnLeftIconClickListener(new OnActionBarChildClickListener(){

            public void onClick(View v) {
                FileSelectorActivity.this.onBackPressed();
            }
        });
        this.abc.setOnRightTextClickListener(new OnActionBarChildClickListener(){

            public void onClick(View v) {
                if (SelectOptions.getInstance().isOnlySelectFolder()) {
                    FileSelectorActivity.this.mSelectedList.add(FileSelectorActivity.this.mCurFolder);
                }
                if (FileSelectorActivity.this.mSelectedList.isEmpty()) {
                    return;
                }
                Intent result = new Intent();
                result.putStringArrayListExtra("extra_result_selection", FileSelectorActivity.this.mSelectedList);
                FileSelectorActivity.this.setResult(-1, result);
                FileSelectorActivity.this.finish();
            }
        });
        if (SelectOptions.getInstance().isOnlyShowFolder()) {
            this.abc.getRightTextView().setText((CharSequence)"\u9009\u4e2d");
        }
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rcv_file_list);
        this.mBreadRecyclerView = (RecyclerView)this.findViewById(R.id.breadcrumbs_view);
        this.mImbSelectSdCard = (ImageView)this.findViewById(R.id.imb_select_sdcard);
        this.mImbSelectSdCard.setOnClickListener((View.OnClickListener)this);
        if (!this.mSdCardList.isEmpty() && this.mSdCardList.size() > 1) {
            this.mImbSelectSdCard.setVisibility(0);
        }
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mAdapter = new FileListAdapter(new ArrayList<EssFile>());
        this.mAdapter.setLoadFileCountListener(this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.onAttachedToRecyclerView(this.mRecyclerView);
        this.mAdapter.setOnItemClickListener(this);
        List<BreadModel> breadModelList = FileUtils.getBreadModeListFromPath(this.mSdCardList, this.mCurFolder);
        this.mBreadRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.mBreadAdapter = new BreadAdapter(breadModelList);
        this.mBreadRecyclerView.setAdapter((RecyclerView.Adapter)this.mBreadAdapter);
        this.mBreadAdapter.onAttachedToRecyclerView(this.mBreadRecyclerView);
        this.mBreadAdapter.setOnItemChildClickListener(this);
    }

    private void initData() {
        this.executeListTask(this.mSelectedFileList, this.mCurFolder, SelectOptions.getInstance().getFileTypes(), SelectOptions.getInstance().getSortType());
    }

    private void executeListTask(List<EssFile> essFileList, String queryPath, String[] types, int sortType) {
        this.essFileListTask = new EssFileListTask(essFileList, queryPath, types, sortType, SelectOptions.getInstance().isOnlyShowFolder(), this);
        this.essFileListTask.execute(new Void[0]);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.imb_select_sdcard) {
            this.showPopupWindow();
        }
    }

    private void showPopupWindow() {
        if (this.mSelectSdCardWindow != null) {
            this.mSelectSdCardWindow.showAsDropDown((View)this.mImbSelectSdCard);
            return;
        }
        View popView = LayoutInflater.from((Context)this).inflate(R.layout.pop_select_sdcard, null);
        this.mSelectSdCardWindow = new PopupWindow(popView, -1, -2);
        this.mSelectSdCardWindow.setFocusable(true);
        this.mSelectSdCardWindow.setOutsideTouchable(true);
        RecyclerView recyclerView = (RecyclerView)popView.findViewById(R.id.rcv_pop_select_sdcard);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        final SelectSdcardAdapter adapter = new SelectSdcardAdapter(FileUtils.getAllSdCardList(this.mSdCardList));
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        adapter.onAttachedToRecyclerView(recyclerView);
        adapter.setOnItemClickListener(new OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapterIn, View view, int position) {
                FileSelectorActivity.this.mSelectSdCardWindow.dismiss();
                FileSelectorActivity.this.mHasChangeSdCard = true;
                FileSelectorActivity.this.executeListTask(FileSelectorActivity.this.mSelectedFileList, FileUtils.getChangeSdCard((String)adapter.getData().get(position), FileSelectorActivity.this.mSdCardList), SelectOptions.getInstance().getFileTypes(), SelectOptions.getInstance().getSortType());
            }
        });
        this.mSelectSdCardWindow.showAsDropDown((View)this.mImbSelectSdCard);
    }

    public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
        if (adapter.equals((Object)this.mBreadAdapter) && view.getId() == R.id.btn_bread) {
            String queryPath = FileUtils.getBreadModelListByPosition(this.mSdCardList, this.mBreadAdapter.getData(), position);
            if (this.mCurFolder.equals(queryPath)) {
                return;
            }
            this.executeListTask(this.mSelectedFileList, queryPath, SelectOptions.getInstance().getFileTypes(), SelectOptions.getInstance().getSortType());
        }
    }

    public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
        if (adapter.equals((Object)this.mAdapter)) {
            EssFile item = (EssFile)this.mAdapter.getData().get(position);
            if (item.isDirectory()) {
                ((BreadModel)this.mBreadAdapter.getData().get(this.mBreadAdapter.getData().size() - 1)).setPrePosition(this.mRecyclerView.computeVerticalScrollOffset());
                this.executeListTask(this.mSelectedFileList, this.mCurFolder + item.getName() + File.separator, SelectOptions.getInstance().getFileTypes(), SelectOptions.getInstance().getSortType());
            } else {
                if (SelectOptions.getInstance().isOnlySelectFolder()) {
                    if (!item.getFile().isDirectory()) {
                        Snackbar.make((View)this.mRecyclerView, (CharSequence)"\u60a8\u53ea\u80fd\u9009\u62e9\u6587\u4ef6\u5939", (int)-1).show();
                    }
                    return;
                }
                if (SelectOptions.getInstance().isSingle) {
                    this.mSelectedFileList.add(item);
                    this.mSelectedList.add(item.getAbsolutePath());
                    Intent result = new Intent();
                    result.putParcelableArrayListExtra("extra_result_selection", this.mSelectedFileList);
                    this.setResult(-1, result);
                    super.onBackPressed();
                    return;
                }
                if (SelectOptions.getInstance().isSingle) {
                    this.mSelectedFileList.add(item);
                    this.mSelectedList.add(item.getAbsolutePath());
                    Intent result = new Intent();
                    result.putParcelableArrayListExtra("extra_result_selection", this.mSelectedFileList);
                    this.setResult(-1, result);
                    super.onBackPressed();
                    return;
                }
                if (((EssFile)this.mAdapter.getData().get(position)).isChecked()) {
                    int index = this.findFileIndex(item);
                    if (index != -1) {
                        this.mSelectedFileList.remove(index);
                        this.mSelectedList.remove(index);
                    }
                } else {
                    if (this.mSelectedFileList.size() >= SelectOptions.getInstance().maxCount) {
                        Snackbar.make((View)this.mRecyclerView, (CharSequence)("\u60a8\u6700\u591a\u53ea\u80fd\u9009\u62e9" + SelectOptions.getInstance().maxCount + "\u4e2a\u3002"), (int)-1).show();
                        return;
                    }
                    this.mSelectedFileList.add(item);
                    this.mSelectedList.add(item.getAbsolutePath());
                }
                ((EssFile)this.mAdapter.getData().get(position)).setChecked(!((EssFile)this.mAdapter.getData().get(position)).isChecked());
                this.mAdapter.notifyDataSetChanged();
                this.abc.getRightTextView().setText((CharSequence)String.format(this.getString(R.string.selected_file_count), String.valueOf(this.mSelectedFileList.size()), String.valueOf(SelectOptions.getInstance().maxCount)));
            }
        }
    }

    private int findFileIndex(EssFile item) {
        for (int i = 0; i < this.mSelectedFileList.size(); ++i) {
            if (!this.mSelectedFileList.get(i).getAbsolutePath().equals(item.getAbsolutePath())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void onLoadFileCount(int posistion) {
        this.essFileCountTask = new EssFileCountTask(posistion, ((EssFile)this.mAdapter.getData().get(posistion)).getAbsolutePath(), SelectOptions.getInstance().getFileTypes(), SelectOptions.getInstance().isOnlyShowFolder(), this);
        this.essFileCountTask.execute(new Void[0]);
    }

    @Override
    public void onFindFileList(String queryPath, List<EssFile> fileList) {
        if (fileList.isEmpty()) {
            this.mAdapter.setEmptyView(R.layout.empty_file_list);
        }
        this.mCurFolder = queryPath;
        this.mAdapter.setNewInstance(fileList);
        List<BreadModel> breadModelList = FileUtils.getBreadModeListFromPath(this.mSdCardList, this.mCurFolder);
        if (this.mHasChangeSdCard) {
            this.mBreadAdapter.setNewInstance(breadModelList);
            this.mHasChangeSdCard = false;
        } else if (breadModelList.size() > this.mBreadAdapter.getData().size()) {
            List<BreadModel> newList = BreadModel.getNewBreadModel(this.mBreadAdapter.getData(), breadModelList);
            this.mBreadAdapter.addData(newList);
        } else {
            int removePosition = BreadModel.getRemovedBreadModel(this.mBreadAdapter.getData(), breadModelList);
            if (removePosition > 0) {
                this.mBreadAdapter.setNewData(this.mBreadAdapter.getData().subList(0, removePosition));
            }
        }
        this.mBreadRecyclerView.smoothScrollToPosition(this.mBreadAdapter.getItemCount() - 1);
        this.mRecyclerView.scrollToPosition(0);
        int scrollYPosition = ((BreadModel)this.mBreadAdapter.getData().get(this.mBreadAdapter.getData().size() - 1)).getPrePosition();
        this.mRecyclerView.scrollBy(0, scrollYPosition);
    }

    @Override
    public void onFindChildFileAndFolderCount(int position, String childFileCount, String childFolderCount) {
        ((EssFile)this.mAdapter.getData().get(position)).setChildCounts(childFileCount, childFolderCount);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onBackPressed() {
        if (!FileUtils.canBackParent(this.mCurFolder, this.mSdCardList)) {
            super.onBackPressed();
            return;
        }
        this.executeListTask(this.mSelectedFileList, new File(this.mCurFolder).getParentFile().getAbsolutePath() + File.separator, SelectOptions.getInstance().getFileTypes(), SelectOptions.getInstance().getSortType());
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.essFileListTask != null) {
            this.essFileListTask.cancel(true);
        }
        if (this.essFileCountTask != null) {
            this.essFileCountTask.cancel(true);
        }
    }
}

