/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib.utils;

import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;

public class FileSizeUtil {
    private static final String TAG = FileSizeUtil.class.getSimpleName();
    public static final int SIZETYPE_B = 1;
    public static final int SIZETYPE_KB = 2;
    public static final int SIZETYPE_MB = 3;
    public static final int SIZETYPE_GB = 4;

    public static double getFileOrFilesSize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileSizeUtil.getFileSizes(file) : FileSizeUtil.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileSizeUtil.FormetFileSize(blockSize, sizeType);
    }

    public static String getAutoFileOrFilesSize(File file) {
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileSizeUtil.getFileSizes(file) : file.length();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileSizeUtil.FormetFileSize(blockSize);
    }

    private static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
        }
        return size;
    }

    private static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileSizeUtil.getFileSizes(flist[i]);
                continue;
            }
            size += FileSizeUtil.getFileSize(flist[i]);
        }
        return size;
    }

    private static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        return fileSizeString;
    }

    private static double FormetFileSize(long fileS, int sizeType) {
        DecimalFormat df = new DecimalFormat("#.00");
        double fileSizeLong = 0.0;
        switch (sizeType) {
            case 1: {
                fileSizeLong = Double.valueOf(df.format((double)fileS));
                break;
            }
            case 2: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1024.0));
                break;
            }
            case 3: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1048576.0));
                break;
            }
            case 4: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1.073741824E9));
                break;
            }
        }
        return fileSizeLong;
    }
}

