/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.fileselectorlib.utils;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.net.Uri;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;

public final class PhotoMetadataUtils {
    private static final String TAG = PhotoMetadataUtils.class.getSimpleName();
    private static final int MAX_WIDTH = 1600;
    private static final String SCHEME_CONTENT = "content";

    private PhotoMetadataUtils() {
        throw new AssertionError((Object)"oops! the utility class is about to be instantiated...");
    }

    public static int getPixelsCount(ContentResolver resolver, Uri uri) {
        Point size = PhotoMetadataUtils.getBitmapBound(resolver, uri);
        return size.x * size.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getBitmapBound(ContentResolver resolver, Uri uri) {
        InputStream is = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            is = resolver.openInputStream(uri);
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            int width = options.outWidth;
            int height = options.outHeight;
            Point point = new Point(width, height);
            return point;
        }
        catch (FileNotFoundException e) {
            Point point = new Point(0, 0);
            return point;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPath(ContentResolver resolver, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (SCHEME_CONTENT.equals(uri.getScheme())) {
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, new String[]{"_data"}, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    String string = null;
                    return string;
                }
                String string = cursor.getString(cursor.getColumnIndex("_data"));
                return string;
            }
        }
        return uri.getPath();
    }

    public static float getSizeInMB(long sizeInBytes) {
        return Float.valueOf(new DecimalFormat("0.0").format((float)sizeInBytes / 1024.0f / 1024.0f)).floatValue();
    }
}

