/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import org.apache.commons.lang3.ArrayUtils;

public class WxCpLinkedCorpMessage
implements Serializable {
    private static final long serialVersionUID = 8833792280163704238L;
    private Boolean isToAll;
    private String[] toUsers;
    private String[] toParties;
    private String[] toTags;
    private Integer agentId;
    private String msgType;
    private String content;
    private String mediaId;
    private String thumbMediaId;
    private String title;
    private String description;
    private Boolean isSafe;
    private String url;
    private String btnTxt;
    private List<NewArticle> articles = new ArrayList<NewArticle>();
    private List<MpnewsArticle> mpNewsArticles = new ArrayList<MpnewsArticle>();
    private String appId;
    private String page;
    private Boolean emphasisFirstItem;
    private Map<String, String> contentItems;

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])this.getToUsers())) {
            messageJson.add("touser", WxGsonBuilder.create().toJsonTree((Object)this.getToUsers()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getToParties())) {
            messageJson.add("toparty", WxGsonBuilder.create().toJsonTree((Object)this.getToParties()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getToTags())) {
            messageJson.add("totag", WxGsonBuilder.create().toJsonTree((Object)this.getToTags()));
        }
        if (this.getIsToAll() != null) {
            messageJson.addProperty("toall", (Number)(this.getIsToAll() != false ? 1 : 0));
        }
        messageJson.addProperty("msgtype", this.getMsgType());
        if (this.getAgentId() != null) {
            messageJson.addProperty("agentid", (Number)this.getAgentId());
        }
        this.handleMsgType(messageJson);
        if (this.getIsSafe() != null) {
            messageJson.addProperty("safe", (Number)(this.getIsSafe() != false ? 1 : 0));
        }
        return messageJson.toString();
    }

    private void handleMsgType(JsonObject messageJson) {
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "textcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                text.addProperty("url", this.getUrl());
                text.addProperty("btntxt", this.getBtnTxt());
                messageJson.add("textcard", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "file": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)image);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", this.getMediaId());
                video.addProperty("title", this.getTitle());
                video.addProperty("description", this.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("description", article.getDescription());
                    articleJson.addProperty("url", article.getUrl());
                    articleJson.addProperty("picurl", article.getPicUrl());
                    articleJson.addProperty("btntxt", article.getBtnText());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject newsJsonObject = new JsonObject();
                if (this.getMediaId() != null) {
                    newsJsonObject.addProperty("media_id", this.getMediaId());
                } else {
                    JsonArray articleJsonArray = new JsonArray();
                    for (MpnewsArticle article : this.getMpNewsArticles()) {
                        JsonObject articleJson = new JsonObject();
                        articleJson.addProperty("title", article.getTitle());
                        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
                        articleJson.addProperty("author", article.getAuthor());
                        articleJson.addProperty("content_source_url", article.getContentSourceUrl());
                        articleJson.addProperty("content", article.getContent());
                        articleJson.addProperty("digest", article.getDigest());
                        if (article.getShowCoverPic() != null) {
                            articleJson.addProperty("show_cover_pic", article.getShowCoverPic());
                        }
                        articleJsonArray.add((JsonElement)articleJson);
                    }
                    newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                }
                messageJson.add("mpnews", (JsonElement)newsJsonObject);
                break;
            }
            case "miniprogram_notice": {
                JsonObject notice = new JsonObject();
                notice.addProperty("appid", this.getAppId());
                notice.addProperty("page", this.getPage());
                notice.addProperty("title", this.getTitle());
                notice.addProperty("description", this.getDescription());
                notice.addProperty("emphasis_first_item", this.getEmphasisFirstItem());
                JsonArray content = new JsonArray();
                for (Map.Entry<String, String> item : this.getContentItems().entrySet()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("key", item.getKey());
                    articleJson.addProperty("value", item.getValue());
                    content.add((JsonElement)articleJson);
                }
                notice.add("content_item", (JsonElement)content);
                messageJson.add("miniprogram_notice", (JsonElement)notice);
                break;
            }
        }
    }

    public static WxCpLinkedCorpMessageBuilder builder() {
        return new WxCpLinkedCorpMessageBuilder();
    }

    public Boolean getIsToAll() {
        return this.isToAll;
    }

    public String[] getToUsers() {
        return this.toUsers;
    }

    public String[] getToParties() {
        return this.toParties;
    }

    public String[] getToTags() {
        return this.toTags;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsSafe() {
        return this.isSafe;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBtnTxt() {
        return this.btnTxt;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public List<MpnewsArticle> getMpNewsArticles() {
        return this.mpNewsArticles;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getEmphasisFirstItem() {
        return this.emphasisFirstItem;
    }

    public Map<String, String> getContentItems() {
        return this.contentItems;
    }

    public WxCpLinkedCorpMessage setIsToAll(Boolean isToAll) {
        this.isToAll = isToAll;
        return this;
    }

    public WxCpLinkedCorpMessage setToUsers(String[] toUsers) {
        this.toUsers = toUsers;
        return this;
    }

    public WxCpLinkedCorpMessage setToParties(String[] toParties) {
        this.toParties = toParties;
        return this;
    }

    public WxCpLinkedCorpMessage setToTags(String[] toTags) {
        this.toTags = toTags;
        return this;
    }

    public WxCpLinkedCorpMessage setAgentId(Integer agentId) {
        this.agentId = agentId;
        return this;
    }

    public WxCpLinkedCorpMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public WxCpLinkedCorpMessage setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public WxCpLinkedCorpMessage setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
        return this;
    }

    public WxCpLinkedCorpMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public WxCpLinkedCorpMessage setDescription(String description) {
        this.description = description;
        return this;
    }

    public WxCpLinkedCorpMessage setIsSafe(Boolean isSafe) {
        this.isSafe = isSafe;
        return this;
    }

    public WxCpLinkedCorpMessage setUrl(String url) {
        this.url = url;
        return this;
    }

    public WxCpLinkedCorpMessage setBtnTxt(String btnTxt) {
        this.btnTxt = btnTxt;
        return this;
    }

    public WxCpLinkedCorpMessage setArticles(List<NewArticle> articles) {
        this.articles = articles;
        return this;
    }

    public WxCpLinkedCorpMessage setMpNewsArticles(List<MpnewsArticle> mpNewsArticles) {
        this.mpNewsArticles = mpNewsArticles;
        return this;
    }

    public WxCpLinkedCorpMessage setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public WxCpLinkedCorpMessage setPage(String page) {
        this.page = page;
        return this;
    }

    public WxCpLinkedCorpMessage setEmphasisFirstItem(Boolean emphasisFirstItem) {
        this.emphasisFirstItem = emphasisFirstItem;
        return this;
    }

    public WxCpLinkedCorpMessage setContentItems(Map<String, String> contentItems) {
        this.contentItems = contentItems;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpLinkedCorpMessage)) {
            return false;
        }
        WxCpLinkedCorpMessage other = (WxCpLinkedCorpMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isToAll = this.getIsToAll();
        Boolean other$isToAll = other.getIsToAll();
        if (this$isToAll == null ? other$isToAll != null : !((Object)this$isToAll).equals(other$isToAll)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getToUsers(), other.getToUsers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getToParties(), other.getToParties())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getToTags(), other.getToTags())) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Boolean this$isSafe = this.getIsSafe();
        Boolean other$isSafe = other.getIsSafe();
        if (this$isSafe == null ? other$isSafe != null : !((Object)this$isSafe).equals(other$isSafe)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$btnTxt = this.getBtnTxt();
        String other$btnTxt = other.getBtnTxt();
        if (this$btnTxt == null ? other$btnTxt != null : !this$btnTxt.equals(other$btnTxt)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        List<MpnewsArticle> this$mpNewsArticles = this.getMpNewsArticles();
        List<MpnewsArticle> other$mpNewsArticles = other.getMpNewsArticles();
        if (this$mpNewsArticles == null ? other$mpNewsArticles != null : !((Object)this$mpNewsArticles).equals(other$mpNewsArticles)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        Boolean this$emphasisFirstItem = this.getEmphasisFirstItem();
        Boolean other$emphasisFirstItem = other.getEmphasisFirstItem();
        if (this$emphasisFirstItem == null ? other$emphasisFirstItem != null : !((Object)this$emphasisFirstItem).equals(other$emphasisFirstItem)) {
            return false;
        }
        Map<String, String> this$contentItems = this.getContentItems();
        Map<String, String> other$contentItems = other.getContentItems();
        return !(this$contentItems == null ? other$contentItems != null : !((Object)this$contentItems).equals(other$contentItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpLinkedCorpMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isToAll = this.getIsToAll();
        result = result * 59 + ($isToAll == null ? 43 : ((Object)$isToAll).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getToUsers());
        result = result * 59 + Arrays.deepHashCode(this.getToParties());
        result = result * 59 + Arrays.deepHashCode(this.getToTags());
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Boolean $isSafe = this.getIsSafe();
        result = result * 59 + ($isSafe == null ? 43 : ((Object)$isSafe).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $btnTxt = this.getBtnTxt();
        result = result * 59 + ($btnTxt == null ? 43 : $btnTxt.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        List<MpnewsArticle> $mpNewsArticles = this.getMpNewsArticles();
        result = result * 59 + ($mpNewsArticles == null ? 43 : ((Object)$mpNewsArticles).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        Boolean $emphasisFirstItem = this.getEmphasisFirstItem();
        result = result * 59 + ($emphasisFirstItem == null ? 43 : ((Object)$emphasisFirstItem).hashCode());
        Map<String, String> $contentItems = this.getContentItems();
        result = result * 59 + ($contentItems == null ? 43 : ((Object)$contentItems).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpLinkedCorpMessage(isToAll=" + this.getIsToAll() + ", toUsers=" + Arrays.deepToString(this.getToUsers()) + ", toParties=" + Arrays.deepToString(this.getToParties()) + ", toTags=" + Arrays.deepToString(this.getToTags()) + ", agentId=" + this.getAgentId() + ", msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", mediaId=" + this.getMediaId() + ", thumbMediaId=" + this.getThumbMediaId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", isSafe=" + this.getIsSafe() + ", url=" + this.getUrl() + ", btnTxt=" + this.getBtnTxt() + ", articles=" + this.getArticles() + ", mpNewsArticles=" + this.getMpNewsArticles() + ", appId=" + this.getAppId() + ", page=" + this.getPage() + ", emphasisFirstItem=" + this.getEmphasisFirstItem() + ", contentItems=" + this.getContentItems() + ")";
    }

    public WxCpLinkedCorpMessage() {
    }

    public WxCpLinkedCorpMessage(Boolean isToAll, String[] toUsers, String[] toParties, String[] toTags, Integer agentId, String msgType, String content, String mediaId, String thumbMediaId, String title, String description, Boolean isSafe, String url, String btnTxt, List<NewArticle> articles, List<MpnewsArticle> mpNewsArticles, String appId, String page, Boolean emphasisFirstItem, Map<String, String> contentItems) {
        this.isToAll = isToAll;
        this.toUsers = toUsers;
        this.toParties = toParties;
        this.toTags = toTags;
        this.agentId = agentId;
        this.msgType = msgType;
        this.content = content;
        this.mediaId = mediaId;
        this.thumbMediaId = thumbMediaId;
        this.title = title;
        this.description = description;
        this.isSafe = isSafe;
        this.url = url;
        this.btnTxt = btnTxt;
        this.articles = articles;
        this.mpNewsArticles = mpNewsArticles;
        this.appId = appId;
        this.page = page;
        this.emphasisFirstItem = emphasisFirstItem;
        this.contentItems = contentItems;
    }

    public static class WxCpLinkedCorpMessageBuilder {
        private Boolean isToAll;
        private String[] toUsers;
        private String[] toParties;
        private String[] toTags;
        private Integer agentId;
        private String msgType;
        private String content;
        private String mediaId;
        private String thumbMediaId;
        private String title;
        private String description;
        private Boolean isSafe;
        private String url;
        private String btnTxt;
        private List<NewArticle> articles;
        private List<MpnewsArticle> mpNewsArticles;
        private String appId;
        private String page;
        private Boolean emphasisFirstItem;
        private Map<String, String> contentItems;

        WxCpLinkedCorpMessageBuilder() {
        }

        public WxCpLinkedCorpMessageBuilder isToAll(Boolean isToAll) {
            this.isToAll = isToAll;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder toUsers(String[] toUsers) {
            this.toUsers = toUsers;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder toParties(String[] toParties) {
            this.toParties = toParties;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder toTags(String[] toTags) {
            this.toTags = toTags;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder agentId(Integer agentId) {
            this.agentId = agentId;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder thumbMediaId(String thumbMediaId) {
            this.thumbMediaId = thumbMediaId;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder isSafe(Boolean isSafe) {
            this.isSafe = isSafe;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder url(String url) {
            this.url = url;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder btnTxt(String btnTxt) {
            this.btnTxt = btnTxt;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder articles(List<NewArticle> articles) {
            this.articles = articles;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder mpNewsArticles(List<MpnewsArticle> mpNewsArticles) {
            this.mpNewsArticles = mpNewsArticles;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder page(String page) {
            this.page = page;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder emphasisFirstItem(Boolean emphasisFirstItem) {
            this.emphasisFirstItem = emphasisFirstItem;
            return this;
        }

        public WxCpLinkedCorpMessageBuilder contentItems(Map<String, String> contentItems) {
            this.contentItems = contentItems;
            return this;
        }

        public WxCpLinkedCorpMessage build() {
            return new WxCpLinkedCorpMessage(this.isToAll, this.toUsers, this.toParties, this.toTags, this.agentId, this.msgType, this.content, this.mediaId, this.thumbMediaId, this.title, this.description, this.isSafe, this.url, this.btnTxt, this.articles, this.mpNewsArticles, this.appId, this.page, this.emphasisFirstItem, this.contentItems);
        }

        public String toString() {
            return "WxCpLinkedCorpMessage.WxCpLinkedCorpMessageBuilder(isToAll=" + this.isToAll + ", toUsers=" + Arrays.deepToString(this.toUsers) + ", toParties=" + Arrays.deepToString(this.toParties) + ", toTags=" + Arrays.deepToString(this.toTags) + ", agentId=" + this.agentId + ", msgType=" + this.msgType + ", content=" + this.content + ", mediaId=" + this.mediaId + ", thumbMediaId=" + this.thumbMediaId + ", title=" + this.title + ", description=" + this.description + ", isSafe=" + this.isSafe + ", url=" + this.url + ", btnTxt=" + this.btnTxt + ", articles=" + this.articles + ", mpNewsArticles=" + this.mpNewsArticles + ", appId=" + this.appId + ", page=" + this.page + ", emphasisFirstItem=" + this.emphasisFirstItem + ", contentItems=" + this.contentItems + ")";
        }
    }
}

