/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.annotation.compiler.IndexerGenerator;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

final class LibraryModuleProcessor {
    private final ProcessorUtil processorUtil;
    private final IndexerGenerator indexerGenerator;

    LibraryModuleProcessor(ProcessorUtil processorUtil, IndexerGenerator indexerGenerator) {
        this.processorUtil = processorUtil;
        this.indexerGenerator = indexerGenerator;
    }

    boolean processModules(RoundEnvironment env) {
        ArrayList<TypeElement> libraryGlideModules = new ArrayList<TypeElement>();
        for (TypeElement element : this.processorUtil.getElementsFor(GlideModule.class, env)) {
            if (this.processorUtil.isAppGlideModule(element)) continue;
            if (!this.processorUtil.isLibraryGlideModule(element)) {
                throw new IllegalStateException("@GlideModule can only be applied to LibraryGlideModule and AppGlideModule implementations, not: " + element);
            }
            libraryGlideModules.add(element);
        }
        this.processorUtil.debugLog("got child modules: " + libraryGlideModules);
        if (libraryGlideModules.isEmpty()) {
            return false;
        }
        TypeSpec indexer = this.indexerGenerator.generate(libraryGlideModules);
        this.processorUtil.writeIndexer(indexer);
        this.processorUtil.debugLog("Wrote an Indexer this round, skipping the app module to ensure all indexers are found");
        return true;
    }

    Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(GlideModule.class.getName());
    }
}

