/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.realm.GenericPrincipal;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.WindowsAccount;

public class GenericWindowsPrincipal
extends GenericPrincipal {
    private byte[] _sid;
    private String _sidString;
    private Map<String, WindowsAccount> _groups;

    public GenericWindowsPrincipal(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat, PrincipalFormat roleFormat) {
        super(windowsIdentity.getFqn(), "", GenericWindowsPrincipal.getRoles(windowsIdentity, principalFormat, roleFormat));
        this._sid = windowsIdentity.getSid();
        this._sidString = windowsIdentity.getSidString();
        this._groups = GenericWindowsPrincipal.getGroups(windowsIdentity.getGroups());
    }

    private static List<String> getRoles(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat, PrincipalFormat roleFormat) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(GenericWindowsPrincipal.getPrincipalNames(windowsIdentity, principalFormat));
        for (IWindowsAccount group : windowsIdentity.getGroups()) {
            roles.addAll(GenericWindowsPrincipal.getRoleNames(group, roleFormat));
        }
        return roles;
    }

    private static Map<String, WindowsAccount> getGroups(IWindowsAccount[] groups) {
        HashMap<String, WindowsAccount> groupMap = new HashMap<String, WindowsAccount>();
        for (IWindowsAccount group : groups) {
            groupMap.put(group.getFqn(), new WindowsAccount(group));
        }
        return groupMap;
    }

    public byte[] getSid() {
        return (byte[])this._sid.clone();
    }

    public String getSidString() {
        return this._sidString;
    }

    public Map<String, WindowsAccount> getGroups() {
        return this._groups;
    }

    private static List<String> getRoleNames(IWindowsAccount group, PrincipalFormat principalFormat) {
        ArrayList<String> principals = new ArrayList<String>();
        switch (principalFormat) {
            case fqn: {
                principals.add(group.getFqn());
                break;
            }
            case sid: {
                principals.add(group.getSidString());
                break;
            }
            case both: {
                principals.add(group.getFqn());
                principals.add(group.getSidString());
                break;
            }
        }
        return principals;
    }

    private static List<String> getPrincipalNames(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<String> principals = new ArrayList<String>();
        switch (principalFormat) {
            case fqn: {
                principals.add(windowsIdentity.getFqn());
                break;
            }
            case sid: {
                principals.add(windowsIdentity.getSidString());
                break;
            }
            case both: {
                principals.add(windowsIdentity.getFqn());
                principals.add(windowsIdentity.getSidString());
                break;
            }
        }
        return principals;
    }

    public String getRolesString() {
        StringBuilder sb = new StringBuilder();
        for (String role : this.getRoles()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(role);
        }
        return sb.toString();
    }
}

