/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.slf4j.LoggerFactory;
import waffle.apache.GenericWindowsPrincipal;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class MixedAuthenticator
extends WaffleAuthenticatorBase {
    public MixedAuthenticator() {
        this._log = LoggerFactory.getLogger(MixedAuthenticator.class);
        this._info = "waffle.apache.MixedAuthenticator/1.0";
        this._log.debug("[waffle.apache.MixedAuthenticator] loaded");
    }

    public synchronized void startInternal() throws LifecycleException {
        this._log.info("[waffle.apache.MixedAuthenticator] started");
        super.startInternal();
    }

    public synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this._log.info("[waffle.apache.MixedAuthenticator] stopped");
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig loginConfig) {
        if (this.context == null || this.context.getRealm() == null) {
            this._log.warn("missing context/realm");
            this.sendError(response, 503);
            return false;
        }
        this._log.debug(request.getMethod() + " " + request.getRequestURI() + ", contentlength: " + request.getContentLength());
        boolean negotiateCheck = request.getParameter("j_negotiate_check") != null;
        this._log.debug("negotiateCheck: " + negotiateCheck);
        boolean securityCheck = request.getParameter("j_security_check") != null;
        this._log.debug("securityCheck: " + securityCheck);
        Principal principal = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug("authorization: " + authorizationHeader.toString() + ", ntlm post: " + ntlmPost);
        if (principal != null && !ntlmPost) {
            this._log.debug("previously authenticated user: " + principal.getName());
            return true;
        }
        if (negotiateCheck) {
            if (!authorizationHeader.isNull()) {
                return this.negotiate(request, response, authorizationHeader);
            }
            this._log.debug("authorization required");
            this.sendUnauthorized(response);
            return false;
        }
        if (securityCheck) {
            boolean postResult = this.post(request, response, loginConfig);
            if (postResult) {
                this.redirectTo(request, response, request.getServletPath());
            } else {
                this.redirectTo(request, response, loginConfig.getErrorPage());
            }
            return postResult;
        }
        this.redirectTo(request, response, loginConfig.getLoginPage());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean negotiate(Request request, HttpServletResponse response, AuthorizationHeader authorizationHeader) {
        String securityPackage = authorizationHeader.getSecurityPackage();
        String connectionId = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
        this._log.debug("security package: " + securityPackage + ", connection id: " + connectionId);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        if (ntlmPost) {
            this._auth.resetSecurityToken(connectionId);
        }
        IWindowsSecurityContext securityContext = null;
        try {
            byte[] tokenBuffer = authorizationHeader.getTokenBytes();
            this._log.debug("token buffer: " + tokenBuffer.length + " byte(s)");
            securityContext = this._auth.acceptSecurityToken(connectionId, tokenBuffer, securityPackage);
            this._log.debug("continue required: " + securityContext.isContinue());
            byte[] continueTokenBytes = securityContext.getToken();
            if (continueTokenBytes != null && continueTokenBytes.length > 0) {
                String continueToken = new String(Base64.encode(continueTokenBytes));
                this._log.debug("continue token: " + continueToken);
                response.addHeader("WWW-Authenticate", securityPackage + " " + continueToken);
            }
            if (securityContext.isContinue() || ntlmPost) {
                response.setHeader("Connection", "keep-alive");
                response.sendError(401);
                response.flushBuffer();
                return false;
            }
        }
        catch (Exception e) {
            this._log.warn("error logging in user: " + e.getMessage());
            this.sendUnauthorized(response);
            return false;
        }
        IWindowsIdentity windowsIdentity = securityContext.getIdentity();
        if (!this._allowGuestLogin && windowsIdentity.isGuest()) {
            this._log.warn("guest login disabled: " + windowsIdentity.getFqn());
            this.sendUnauthorized(response);
            return false;
        }
        try {
            this._log.debug("logged in user: " + windowsIdentity.getFqn() + " (" + windowsIdentity.getSidString() + ")");
            GenericWindowsPrincipal windowsPrincipal = new GenericWindowsPrincipal(windowsIdentity, this._principalFormat, this._roleFormat);
            this._log.debug("roles: " + windowsPrincipal.getRolesString());
            HttpSession session = request.getSession(true);
            this._log.debug("session id:" + session.getId());
            this.register(request, response, (Principal)((Object)windowsPrincipal), securityPackage, windowsPrincipal.getName(), null);
            this._log.info("successfully logged in user: " + windowsPrincipal.getName());
        }
        finally {
            windowsIdentity.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean post(Request request, HttpServletResponse response, LoginConfig loginConfig) {
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        this._log.debug("logging in: " + username);
        IWindowsIdentity windowsIdentity = null;
        try {
            windowsIdentity = this._auth.logonUser(username, password);
        }
        catch (Exception e) {
            this._log.error(e.getMessage());
            return false;
        }
        if (!this._allowGuestLogin && windowsIdentity.isGuest()) {
            this._log.warn("guest login disabled: " + windowsIdentity.getFqn());
            return false;
        }
        try {
            this._log.debug("successfully logged in " + username + " (" + windowsIdentity.getSidString() + ")");
            GenericWindowsPrincipal windowsPrincipal = new GenericWindowsPrincipal(windowsIdentity, this._principalFormat, this._roleFormat);
            this._log.debug("roles: " + windowsPrincipal.getRolesString());
            HttpSession session = request.getSession(true);
            this._log.debug("session id:" + session.getId());
            this.register(request, response, (Principal)((Object)windowsPrincipal), "FORM", windowsPrincipal.getName(), null);
            this._log.info("successfully logged in user: " + windowsPrincipal.getName());
        }
        finally {
            windowsIdentity.dispose();
        }
        return true;
    }

    private void redirectTo(Request request, HttpServletResponse response, String url) {
        try {
            this._log.debug("redirecting to: " + url);
            ServletContext servletContext = this.context.getServletContext();
            RequestDispatcher disp = servletContext.getRequestDispatcher(url);
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (IOException e) {
            this._log.error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (ServletException e) {
            this._log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

