/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.slf4j.LoggerFactory;
import waffle.apache.GenericWindowsPrincipal;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class NegotiateAuthenticator
extends WaffleAuthenticatorBase {
    public NegotiateAuthenticator() {
        this._log = LoggerFactory.getLogger(NegotiateAuthenticator.class);
        this._info = "waffle.apache.NegotiateAuthenticator/1.0";
        this._log.debug("[waffle.apache.NegotiateAuthenticator] loaded");
    }

    public synchronized void startInternal() throws LifecycleException {
        this._log.info("[waffle.apache.NegotiateAuthenticator] started");
        super.startInternal();
    }

    public synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this._log.info("[waffle.apache.NegotiateAuthenticator] stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig loginConfig) {
        Object principal = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug(request.getMethod() + " " + request.getRequestURI() + ", contentlength: " + request.getContentLength());
        this._log.debug("authorization: " + authorizationHeader.toString() + ", ntlm post: " + ntlmPost);
        if (principal != null && !ntlmPost) {
            this._log.debug("previously authenticated user: " + principal.getName());
            return true;
        }
        if (!authorizationHeader.isNull()) {
            IWindowsSecurityContext securityContext;
            String securityPackage = authorizationHeader.getSecurityPackage();
            String connectionId = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
            this._log.debug("security package: " + securityPackage + ", connection id: " + connectionId);
            if (ntlmPost) {
                this._auth.resetSecurityToken(connectionId);
            }
            try {
                byte[] tokenBuffer = authorizationHeader.getTokenBytes();
                this._log.debug("token buffer: " + tokenBuffer.length + " byte(s)");
                securityContext = this._auth.acceptSecurityToken(connectionId, tokenBuffer, securityPackage);
                this._log.debug("continue required: " + securityContext.isContinue());
                byte[] continueTokenBytes = securityContext.getToken();
                if (continueTokenBytes != null && continueTokenBytes.length > 0) {
                    String continueToken = new String(Base64.encode(continueTokenBytes));
                    this._log.debug("continue token: " + continueToken);
                    response.addHeader("WWW-Authenticate", securityPackage + " " + continueToken);
                }
                if (securityContext.isContinue() || ntlmPost) {
                    response.setHeader("Connection", "keep-alive");
                    response.sendError(401);
                    response.flushBuffer();
                    return false;
                }
            }
            catch (Exception e) {
                this._log.warn("error logging in user: " + e.getMessage());
                this.sendUnauthorized(response);
                return false;
            }
            if (this.context == null || this.context.getRealm() == null) {
                this._log.warn("missing context/realm");
                this.sendError(response, 503);
                return false;
            }
            IWindowsIdentity windowsIdentity = securityContext.getIdentity();
            if (!this._allowGuestLogin && windowsIdentity.isGuest()) {
                this._log.warn("guest login disabled: " + windowsIdentity.getFqn());
                this.sendUnauthorized(response);
                return false;
            }
            try {
                this._log.debug("logged in user: " + windowsIdentity.getFqn() + " (" + windowsIdentity.getSidString() + ")");
                GenericWindowsPrincipal windowsPrincipal = new GenericWindowsPrincipal(windowsIdentity, this._principalFormat, this._roleFormat);
                this._log.debug("roles: " + windowsPrincipal.getRolesString());
                principal = windowsPrincipal;
                HttpSession session = request.getSession(true);
                this._log.debug("session id:" + session.getId());
                this.register(request, response, (Principal)principal, securityPackage, principal.getName(), null);
                this._log.info("successfully logged in user: " + principal.getName());
            }
            finally {
                windowsIdentity.dispose();
            }
            return true;
        }
        this._log.debug("authorization required");
        this.sendUnauthorized(response);
        return false;
    }
}

