/*
 * Decompiled with CFR 0.152.
 */
package waffle.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import waffle.jaas.RolePrincipal;
import waffle.jaas.UserPrincipal;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WindowsLoginModule
implements LoginModule {
    private String _username = null;
    private boolean _debug = false;
    private Subject _subject = null;
    private CallbackHandler _callbackHandler = null;
    private IWindowsAuthProvider _auth = new WindowsAuthProviderImpl();
    private Set<Principal> _principals = null;
    private PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    private PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    private boolean _allowGuestLogin = true;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        for (Map.Entry<String, ?> option : options.entrySet()) {
            if (option.getKey().equalsIgnoreCase("debug")) {
                this._debug = Boolean.parseBoolean((String)option.getValue());
                continue;
            }
            if (option.getKey().equalsIgnoreCase("principalFormat")) {
                this._principalFormat = PrincipalFormat.valueOf((String)option.getValue());
                continue;
            }
            if (!option.getKey().equalsIgnoreCase("roleFormat")) continue;
            this._roleFormat = PrincipalFormat.valueOf((String)option.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        if (this._callbackHandler == null) {
            throw new LoginException("Missing callback to gather information from the user.");
        }
        NameCallback usernameCallback = new NameCallback("user name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        Callback[] callbacks = new Callback[]{usernameCallback, passwordCallback};
        String username = null;
        String password = null;
        try {
            this._callbackHandler.handle(callbacks);
            username = usernameCallback.getName();
            password = passwordCallback.getPassword() == null ? "" : new String(passwordCallback.getPassword());
            passwordCallback.clearPassword();
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Callback " + e.getCallback().getClass().getName() + " not available to gather authentication information from the user.");
        }
        IWindowsIdentity windowsIdentity = null;
        try {
            windowsIdentity = this._auth.logonUser(username, password);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        try {
            if (!this._allowGuestLogin && windowsIdentity.isGuest()) {
                this.debug("guest login disabled: " + windowsIdentity.getFqn());
                throw new LoginException("Guest login disabled");
            }
            this._principals = new LinkedHashSet<Principal>();
            this._principals.addAll(WindowsLoginModule.getUserPrincipals(windowsIdentity, this._principalFormat));
            if (this._roleFormat != PrincipalFormat.none) {
                for (IWindowsAccount group : windowsIdentity.getGroups()) {
                    this._principals.addAll(WindowsLoginModule.getRolePrincipals(group, this._roleFormat));
                }
            }
            this._username = windowsIdentity.getFqn();
            this.debug("successfully logged in " + this._username + " (" + windowsIdentity.getSidString() + ")");
        }
        finally {
            windowsIdentity.dispose();
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean commit() throws LoginException {
        if (this._principals == null) {
            return false;
        }
        if (this._subject.isReadOnly()) {
            throw new LoginException("Subject cannot be read-only.");
        }
        Set<Principal> principals = this._subject.getPrincipals();
        principals.addAll(this._principals);
        this.debug("committing " + this._subject.getPrincipals().size() + " principals");
        if (this._debug) {
            for (Principal principal : principals) {
                this.debug(" principal: " + principal.getName());
            }
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this._subject.isReadOnly()) {
            throw new LoginException("Subject cannot be read-only.");
        }
        this._subject.getPrincipals().clear();
        if (this._username != null) {
            this.debug("logging out " + this._username);
        }
        return true;
    }

    private void debug(String message) {
        if (this._debug) {
            System.out.println("[waffle.jaas.WindowsLoginModule] " + message);
        }
    }

    public boolean isDebug() {
        return this._debug;
    }

    public IWindowsAuthProvider getAuth() {
        return this._auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this._auth = provider;
    }

    private static List<Principal> getUserPrincipals(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        switch (principalFormat) {
            case fqn: {
                principals.add(new UserPrincipal(windowsIdentity.getFqn()));
                break;
            }
            case sid: {
                principals.add(new UserPrincipal(windowsIdentity.getSidString()));
                break;
            }
            case both: {
                principals.add(new UserPrincipal(windowsIdentity.getFqn()));
                principals.add(new UserPrincipal(windowsIdentity.getSidString()));
                break;
            }
        }
        return principals;
    }

    private static List<Principal> getRolePrincipals(IWindowsAccount group, PrincipalFormat principalFormat) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        switch (principalFormat) {
            case fqn: {
                principals.add(new RolePrincipal(group.getFqn()));
                break;
            }
            case sid: {
                principals.add(new RolePrincipal(group.getSidString()));
                break;
            }
            case both: {
                principals.add(new RolePrincipal(group.getFqn()));
                principals.add(new RolePrincipal(group.getSidString()));
                break;
            }
        }
        return principals;
    }

    public boolean isAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this._allowGuestLogin = value;
    }
}

