/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.security.InvalidParameterException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;

public class BasicSecurityFilterProvider
implements SecurityFilterProvider {
    private Logger _log = LoggerFactory.getLogger(BasicSecurityFilterProvider.class);
    private String _realm = "BasicSecurityFilterProvider";
    private IWindowsAuthProvider _auth = null;

    public BasicSecurityFilterProvider(IWindowsAuthProvider auth) {
        this._auth = auth;
    }

    @Override
    public IWindowsIdentity doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        String usernamePassword = new String(authorizationHeader.getTokenBytes());
        String[] usernamePasswordArray = usernamePassword.split(":", 2);
        if (usernamePasswordArray.length != 2) {
            throw new RuntimeException("Invalid username:password in Authorization header.");
        }
        this._log.debug("logging in user: " + usernamePasswordArray[0]);
        return this._auth.logonUser(usernamePasswordArray[0], usernamePasswordArray[1]);
    }

    @Override
    public boolean isPrincipalException(HttpServletRequest request) {
        return false;
    }

    @Override
    public boolean isSecurityPackageSupported(String securityPackage) {
        return securityPackage.equalsIgnoreCase("Basic");
    }

    @Override
    public void sendUnauthorized(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + this._realm + "\"");
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    @Override
    public void initParameter(String parameterName, String parameterValue) {
        if (!parameterName.equals("realm")) {
            throw new InvalidParameterException(parameterName);
        }
        this.setRealm(parameterValue);
    }
}

