/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Netapi32Util;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsDomain;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsComputerImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsDomainImpl;
import waffle.windows.auth.impl.WindowsIdentityImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class WindowsAuthProviderImpl
implements IWindowsAuthProvider {
    private Cache<String, Sspi.CtxtHandle> _continueContexts = null;

    public WindowsAuthProviderImpl() {
        this(30);
    }

    public WindowsAuthProviderImpl(int continueContextsTimeout) {
        this._continueContexts = CacheBuilder.newBuilder().expireAfterWrite((long)continueContextsTimeout, TimeUnit.SECONDS).build();
    }

    @Override
    public IWindowsSecurityContext acceptSecurityToken(String connectionId, byte[] token, String securityPackage) {
        if (token == null || token.length == 0) {
            this._continueContexts.asMap().remove(connectionId);
            throw new Win32Exception(-2146893048);
        }
        WindowsCredentialsHandleImpl serverCredential = new WindowsCredentialsHandleImpl(null, 1, securityPackage);
        serverCredential.initialize();
        WindowsSecurityContextImpl sc = null;
        int rc = 0;
        int tokenSize = 12288;
        do {
            Sspi.SecBufferDesc pbServerToken = new Sspi.SecBufferDesc(2, tokenSize);
            Sspi.SecBufferDesc pbClientToken = new Sspi.SecBufferDesc(2, token);
            IntByReference pfClientContextAttr = new IntByReference();
            Sspi.CtxtHandle continueContext = (Sspi.CtxtHandle)this._continueContexts.asMap().get(connectionId);
            Sspi.CtxtHandle phNewServerContext = new Sspi.CtxtHandle();
            rc = Secur32.INSTANCE.AcceptSecurityContext(serverCredential.getHandle(), continueContext, pbClientToken, 2048, 16, phNewServerContext, pbServerToken, pfClientContextAttr, null);
            sc = new WindowsSecurityContextImpl();
            sc.setCredentialsHandle(serverCredential.getHandle());
            sc.setSecurityPackage(securityPackage);
            sc.setSecurityContext(phNewServerContext);
            switch (rc) {
                case -2146893023: {
                    tokenSize += 12288;
                    sc.dispose();
                    WindowsSecurityContextImpl.dispose(continueContext);
                    break;
                }
                case 0: {
                    this._continueContexts.asMap().remove(connectionId);
                    if (pbServerToken != null && pbServerToken.pBuffers != null && pbServerToken.cBuffers == 1 && pbServerToken.pBuffers[0].cbBuffer > 0) {
                        sc.setToken(pbServerToken.getBytes());
                    }
                    sc.setContinue(false);
                    break;
                }
                case 590610: {
                    this._continueContexts.put((Object)connectionId, (Object)phNewServerContext);
                    sc.setToken(pbServerToken.getBytes());
                    sc.setContinue(true);
                    break;
                }
                default: {
                    sc.dispose();
                    WindowsSecurityContextImpl.dispose(continueContext);
                    this._continueContexts.asMap().remove(connectionId);
                    throw new Win32Exception(rc);
                }
            }
        } while (rc == -2146893023);
        return sc;
    }

    @Override
    public IWindowsComputer getCurrentComputer() {
        try {
            return new WindowsComputerImpl(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IWindowsDomain[] getDomains() {
        Netapi32Util.DomainTrust[] trusts;
        ArrayList<WindowsDomainImpl> domains = new ArrayList<WindowsDomainImpl>();
        for (Netapi32Util.DomainTrust trust : trusts = Netapi32Util.getDomainTrusts()) {
            domains.add(new WindowsDomainImpl(trust));
        }
        return domains.toArray(new IWindowsDomain[0]);
    }

    @Override
    public IWindowsIdentity logonDomainUser(String username, String domain, String password) {
        return this.logonDomainUserEx(username, domain, password, 3, 0);
    }

    @Override
    public IWindowsIdentity logonDomainUserEx(String username, String domain, String password, int logonType, int logonProvider) {
        WinNT.HANDLEByReference phUser = new WinNT.HANDLEByReference();
        if (!Advapi32.INSTANCE.LogonUser(username, domain, password, logonType, logonProvider, phUser)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new WindowsIdentityImpl(phUser.getValue());
    }

    @Override
    public IWindowsIdentity logonUser(String username, String password) {
        String[] userNameDomain = username.split("\\\\", 2);
        if (userNameDomain.length == 2) {
            return this.logonDomainUser(userNameDomain[1], userNameDomain[0], password);
        }
        return this.logonDomainUser(username, null, password);
    }

    @Override
    public IWindowsAccount lookupAccount(String username) {
        return new WindowsAccountImpl(username);
    }

    @Override
    public void resetSecurityToken(String connectionId) {
        this._continueContexts.asMap().remove(connectionId);
    }

    public int getContinueContextsSize() {
        return this._continueContexts.asMap().size();
    }
}

