/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Netapi32Util;
import waffle.windows.auth.IWindowsDomain;

public class WindowsDomainImpl
implements IWindowsDomain {
    private String _fqn;
    private TrustDirection _trustDirection = TrustDirection.Bidirectional;
    private TrustType _trustType = TrustType.Unknown;

    @Override
    public String getFqn() {
        return this._fqn;
    }

    @Override
    public String getTrustDirectionString() {
        return this._trustDirection.toString();
    }

    @Override
    public String getTrustTypeString() {
        return this._trustType.toString();
    }

    public WindowsDomainImpl(String fqn) {
        this._fqn = fqn;
    }

    public WindowsDomainImpl(Netapi32Util.DomainTrust trust) {
        this._fqn = trust.DnsDomainName;
        if (this._fqn == null || this._fqn.length() == 0) {
            this._fqn = trust.NetbiosDomainName;
        }
        if (trust.isInbound() && trust.isOutbound()) {
            this._trustDirection = TrustDirection.Bidirectional;
        } else if (trust.isOutbound()) {
            this._trustDirection = TrustDirection.Outbound;
        } else if (trust.isInbound()) {
            this._trustDirection = TrustDirection.Inbound;
        }
        if (trust.isInForest()) {
            this._trustType = TrustType.Forest;
        } else if (trust.isRoot()) {
            this._trustType = TrustType.TreeRoot;
        }
    }

    private static enum TrustType {
        TreeRoot,
        ParentChild,
        CrossLink,
        External,
        Forest,
        Kerberos,
        Unknown;

    }

    private static enum TrustDirection {
        Inbound,
        Outbound,
        Bidirectional;

    }
}

