/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsIdentityImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpersonationContextImpl;

public class WindowsSecurityContextImpl
implements IWindowsSecurityContext {
    private String _principalName;
    private String _securityPackage;
    private Sspi.SecBufferDesc _token = null;
    private Sspi.CtxtHandle _ctx = null;
    private IntByReference _attr;
    private Sspi.CredHandle _credentials;
    private boolean _continue;

    @Override
    public IWindowsIdentity getIdentity() {
        WinNT.HANDLEByReference phContextToken = new WinNT.HANDLEByReference();
        int rc = Secur32.INSTANCE.QuerySecurityContextToken(this._ctx, phContextToken);
        if (0 != rc) {
            throw new Win32Exception(rc);
        }
        return new WindowsIdentityImpl(phContextToken.getValue());
    }

    @Override
    public String getSecurityPackage() {
        return this._securityPackage;
    }

    @Override
    public byte[] getToken() {
        return this._token == null ? null : (byte[])this._token.getBytes().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWindowsSecurityContext getCurrent(String securityPackage, String targetName) {
        IWindowsCredentialsHandle credentialsHandle = WindowsCredentialsHandleImpl.getCurrent(securityPackage);
        credentialsHandle.initialize();
        try {
            WindowsSecurityContextImpl ctx = new WindowsSecurityContextImpl();
            ctx.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
            ctx.setCredentialsHandle(credentialsHandle.getHandle());
            ctx.setSecurityPackage(securityPackage);
            ctx.initialize(null, null, targetName);
            WindowsSecurityContextImpl windowsSecurityContextImpl = ctx;
            return windowsSecurityContextImpl;
        }
        finally {
            credentialsHandle.dispose();
        }
    }

    @Override
    public void initialize(Sspi.CtxtHandle continueCtx, Sspi.SecBufferDesc continueToken, String targetName) {
        this._attr = new IntByReference();
        this._ctx = new Sspi.CtxtHandle();
        int tokenSize = 12288;
        int rc = 0;
        do {
            this._token = new Sspi.SecBufferDesc(2, tokenSize);
            rc = Secur32.INSTANCE.InitializeSecurityContext(this._credentials, continueCtx, targetName, 2048, 0, 16, continueToken, 0, this._ctx, this._token, this._attr, null);
            switch (rc) {
                case -2146893056: {
                    tokenSize += 12288;
                    break;
                }
                case 590610: {
                    this._continue = true;
                    break;
                }
                case 0: {
                    this._continue = false;
                    break;
                }
                default: {
                    throw new Win32Exception(rc);
                }
            }
        } while (rc == -2146893056);
    }

    @Override
    public void dispose() {
        WindowsSecurityContextImpl.dispose(this._ctx);
    }

    public static boolean dispose(Sspi.CtxtHandle ctx) {
        if (ctx != null && !ctx.isNull()) {
            int rc = Secur32.INSTANCE.DeleteSecurityContext(ctx);
            if (0 != rc) {
                throw new Win32Exception(rc);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getPrincipalName() {
        return this._principalName;
    }

    public void setPrincipalName(String principalName) {
        this._principalName = principalName;
    }

    @Override
    public Sspi.CtxtHandle getHandle() {
        return this._ctx;
    }

    public void setCredentialsHandle(Sspi.CredHandle handle) {
        this._credentials = handle;
    }

    public void setToken(byte[] bytes) {
        this._token = new Sspi.SecBufferDesc(2, bytes);
    }

    public void setSecurityPackage(String securityPackage) {
        this._securityPackage = securityPackage;
    }

    public void setSecurityContext(Sspi.CtxtHandle phNewServerContext) {
        this._ctx = phNewServerContext;
    }

    @Override
    public boolean isContinue() {
        return this._continue;
    }

    public void setContinue(boolean b) {
        this._continue = b;
    }

    @Override
    public IWindowsImpersonationContext impersonate() {
        return new WindowsSecurityContextImpersonationContextImpl(this._ctx);
    }
}

