/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.groupedadapter.adapter;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.donkingliang.groupedadapter.R;
import com.donkingliang.groupedadapter.holder.BaseViewHolder;
import com.donkingliang.groupedadapter.structure.GroupStructure;
import java.util.ArrayList;

public abstract class GroupedRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int TYPE_HEADER = R.integer.type_header;
    public static final int TYPE_FOOTER = R.integer.type_footer;
    public static final int TYPE_CHILD = R.integer.type_child;
    public static final int TYPE_EMPTY = R.integer.type_empty;
    private OnHeaderClickListener mOnHeaderClickListener;
    private OnFooterClickListener mOnFooterClickListener;
    private OnChildClickListener mOnChildClickListener;
    protected Context mContext;
    protected ArrayList<GroupStructure> mStructures = new ArrayList();
    private boolean isDataChanged;
    private int mTempPosition;
    private boolean mUseBinding;
    private boolean showEmptyView = false;

    public GroupedRecyclerViewAdapter(Context context) {
        this(context, false);
    }

    public GroupedRecyclerViewAdapter(Context context, boolean useBinding) {
        this.mContext = context;
        this.mUseBinding = useBinding;
        this.registerAdapterDataObserver(new GroupDataObserver());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.structureChanged();
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        if (this.isStaggeredGridLayout(holder)) {
            this.handleLayoutIfStaggeredGridLayout(holder, holder.getLayoutPosition());
        }
    }

    private boolean isStaggeredGridLayout(RecyclerView.ViewHolder holder) {
        ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
        return layoutParams instanceof StaggeredGridLayoutManager.LayoutParams;
    }

    private void handleLayoutIfStaggeredGridLayout(RecyclerView.ViewHolder holder, int position) {
        if (this.isEmptyPosition(position) || this.judgeType(position) == TYPE_HEADER || this.judgeType(position) == TYPE_FOOTER) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            p.setFullSpan(true);
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == TYPE_EMPTY) {
            return new BaseViewHolder(this.getEmptyView(parent));
        }
        if (this.mUseBinding) {
            ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.mContext), (int)this.getLayoutId(this.mTempPosition, viewType), (ViewGroup)parent, (boolean)false);
            return new BaseViewHolder(binding.getRoot());
        }
        View view = LayoutInflater.from((Context)this.mContext).inflate(this.getLayoutId(this.mTempPosition, viewType), parent, false);
        return new BaseViewHolder(view);
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        int type = this.judgeType(position);
        final int groupPosition = this.getGroupPositionForPosition(position);
        if (type == TYPE_HEADER) {
            if (this.mOnHeaderClickListener != null) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GroupedRecyclerViewAdapter.this.mOnHeaderClickListener != null) {
                            int gPosition;
                            ViewParent parent = holder.itemView.getParent();
                            int n = gPosition = parent instanceof FrameLayout ? groupPosition : GroupedRecyclerViewAdapter.this.getGroupPositionForPosition(holder.getLayoutPosition());
                            if (gPosition >= 0 && gPosition < GroupedRecyclerViewAdapter.this.mStructures.size()) {
                                GroupedRecyclerViewAdapter.this.mOnHeaderClickListener.onHeaderClick(GroupedRecyclerViewAdapter.this, (BaseViewHolder)holder, gPosition);
                            }
                        }
                    }
                });
            }
            this.onBindHeaderViewHolder((BaseViewHolder)holder, groupPosition);
        } else if (type == TYPE_FOOTER) {
            if (this.mOnFooterClickListener != null) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int gPosition;
                        if (GroupedRecyclerViewAdapter.this.mOnFooterClickListener != null && (gPosition = GroupedRecyclerViewAdapter.this.getGroupPositionForPosition(holder.getLayoutPosition())) >= 0 && gPosition < GroupedRecyclerViewAdapter.this.mStructures.size()) {
                            GroupedRecyclerViewAdapter.this.mOnFooterClickListener.onFooterClick(GroupedRecyclerViewAdapter.this, (BaseViewHolder)holder, gPosition);
                        }
                    }
                });
            }
            this.onBindFooterViewHolder((BaseViewHolder)holder, groupPosition);
        } else if (type == TYPE_CHILD) {
            int childPosition = this.getChildPositionForPosition(groupPosition, position);
            if (this.mOnChildClickListener != null) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GroupedRecyclerViewAdapter.this.mOnChildClickListener != null) {
                            int gPosition = GroupedRecyclerViewAdapter.this.getGroupPositionForPosition(holder.getLayoutPosition());
                            int cPosition = GroupedRecyclerViewAdapter.this.getChildPositionForPosition(gPosition, holder.getLayoutPosition());
                            if (gPosition >= 0 && gPosition < GroupedRecyclerViewAdapter.this.mStructures.size() && cPosition >= 0 && cPosition < GroupedRecyclerViewAdapter.this.mStructures.get(gPosition).getChildrenCount()) {
                                GroupedRecyclerViewAdapter.this.mOnChildClickListener.onChildClick(GroupedRecyclerViewAdapter.this, (BaseViewHolder)holder, gPosition, cPosition);
                            }
                        }
                    }
                });
            }
            this.onBindChildViewHolder((BaseViewHolder)holder, groupPosition, childPosition);
        }
    }

    public int getItemCount() {
        int count;
        if (this.isDataChanged) {
            this.structureChanged();
        }
        if ((count = this.count()) > 0) {
            return count;
        }
        if (this.showEmptyView) {
            return 1;
        }
        return 0;
    }

    public boolean isEmptyPosition(int position) {
        return position == 0 && this.showEmptyView && this.count() == 0;
    }

    public int getItemViewType(int position) {
        if (this.isEmptyPosition(position)) {
            return TYPE_EMPTY;
        }
        this.mTempPosition = position;
        int groupPosition = this.getGroupPositionForPosition(position);
        int type = this.judgeType(position);
        if (type == TYPE_HEADER) {
            return this.getHeaderViewType(groupPosition);
        }
        if (type == TYPE_FOOTER) {
            return this.getFooterViewType(groupPosition);
        }
        if (type == TYPE_CHILD) {
            int childPosition = this.getChildPositionForPosition(groupPosition, position);
            return this.getChildViewType(groupPosition, childPosition);
        }
        return super.getItemViewType(position);
    }

    public int getHeaderViewType(int groupPosition) {
        return TYPE_HEADER;
    }

    public int getFooterViewType(int groupPosition) {
        return TYPE_FOOTER;
    }

    public int getChildViewType(int groupPosition, int childPosition) {
        return TYPE_CHILD;
    }

    private int getLayoutId(int position, int viewType) {
        int type = this.judgeType(position);
        if (type == TYPE_HEADER) {
            return this.getHeaderLayout(viewType);
        }
        if (type == TYPE_FOOTER) {
            return this.getFooterLayout(viewType);
        }
        if (type == TYPE_CHILD) {
            return this.getChildLayout(viewType);
        }
        return 0;
    }

    private int count() {
        return this.countGroupRangeItem(0, this.mStructures.size());
    }

    public int judgeType(int position) {
        int itemCount = 0;
        int groupCount = this.mStructures.size();
        for (int i = 0; i < groupCount; ++i) {
            GroupStructure structure = this.mStructures.get(i);
            if (structure.hasHeader() && position < ++itemCount) {
                return TYPE_HEADER;
            }
            if (position < (itemCount += structure.getChildrenCount())) {
                return TYPE_CHILD;
            }
            if (!structure.hasFooter() || position >= ++itemCount) continue;
            return TYPE_FOOTER;
        }
        return TYPE_EMPTY;
    }

    private void structureChanged() {
        this.mStructures.clear();
        int groupCount = this.getGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            this.mStructures.add(new GroupStructure(this.hasHeader(i), this.hasFooter(i), this.getChildrenCount(i)));
        }
        this.isDataChanged = false;
    }

    public int getGroupPositionForPosition(int position) {
        int count = 0;
        int groupCount = this.mStructures.size();
        for (int i = 0; i < groupCount; ++i) {
            if (position >= (count += this.countGroupItem(i))) continue;
            return i;
        }
        return -1;
    }

    public int getChildPositionForPosition(int groupPosition, int position) {
        if (groupPosition >= 0 && groupPosition < this.mStructures.size()) {
            int itemCount = this.countGroupRangeItem(0, groupPosition + 1);
            GroupStructure structure = this.mStructures.get(groupPosition);
            int p = structure.getChildrenCount() - (itemCount - position) + (structure.hasFooter() ? 1 : 0);
            if (p >= 0) {
                return p;
            }
        }
        return -1;
    }

    public int getPositionForGroup(int groupPosition) {
        if (groupPosition >= 0 && groupPosition < this.mStructures.size()) {
            return this.countGroupRangeItem(0, groupPosition);
        }
        return -1;
    }

    public int getPositionForGroupHeader(int groupPosition) {
        if (groupPosition >= 0 && groupPosition < this.mStructures.size()) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            if (!structure.hasHeader()) {
                return -1;
            }
            return this.countGroupRangeItem(0, groupPosition);
        }
        return -1;
    }

    public int getPositionForGroupFooter(int groupPosition) {
        if (groupPosition >= 0 && groupPosition < this.mStructures.size()) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            if (!structure.hasFooter()) {
                return -1;
            }
            return this.countGroupRangeItem(0, groupPosition + 1) - 1;
        }
        return -1;
    }

    public int getPositionForChild(int groupPosition, int childPosition) {
        GroupStructure structure;
        if (groupPosition >= 0 && groupPosition < this.mStructures.size() && (structure = this.mStructures.get(groupPosition)).getChildrenCount() > childPosition) {
            int itemCount = this.countGroupRangeItem(0, groupPosition);
            return itemCount + childPosition + (structure.hasHeader() ? 1 : 0);
        }
        return -1;
    }

    public int countGroupItem(int groupPosition) {
        int itemCount = 0;
        if (groupPosition >= 0 && groupPosition < this.mStructures.size()) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            if (structure.hasHeader()) {
                ++itemCount;
            }
            itemCount += structure.getChildrenCount();
            if (structure.hasFooter()) {
                ++itemCount;
            }
        }
        return itemCount;
    }

    public int countGroupRangeItem(int start, int count) {
        int itemCount = 0;
        int size = this.mStructures.size();
        for (int i = start; i < size && i < start + count; ++i) {
            itemCount += this.countGroupItem(i);
        }
        return itemCount;
    }

    public void showEmptyView(boolean isShow) {
        if (isShow != this.showEmptyView) {
            this.showEmptyView = isShow;
            this.notifyDataChanged();
        }
    }

    public boolean isShowEmptyView() {
        return this.showEmptyView;
    }

    @Deprecated
    public void changeDataSet() {
        this.notifyDataChanged();
    }

    public void notifyDataChanged() {
        this.isDataChanged = true;
        this.notifyDataSetChanged();
    }

    @Deprecated
    public void changeGroup(int groupPosition) {
        this.notifyGroupChanged(groupPosition);
    }

    public void notifyGroupChanged(int groupPosition) {
        int index = this.getPositionForGroup(groupPosition);
        int itemCount = this.countGroupItem(groupPosition);
        if (index >= 0 && itemCount > 0) {
            this.notifyItemRangeChanged(index, itemCount);
        }
    }

    @Deprecated
    public void changeRangeGroup(int groupPosition, int count) {
        this.notifyGroupRangeChanged(groupPosition, count);
    }

    public void notifyGroupRangeChanged(int groupPosition, int count) {
        int index = this.getPositionForGroup(groupPosition);
        int itemCount = 0;
        itemCount = groupPosition + count <= this.mStructures.size() ? this.countGroupRangeItem(groupPosition, groupPosition + count) : this.countGroupRangeItem(groupPosition, this.mStructures.size());
        if (index >= 0 && itemCount > 0) {
            this.notifyItemRangeChanged(index, itemCount);
        }
    }

    @Deprecated
    public void changeHeader(int groupPosition) {
        this.notifyHeaderChanged(groupPosition);
    }

    public void notifyHeaderChanged(int groupPosition) {
        int index = this.getPositionForGroupHeader(groupPosition);
        if (index >= 0) {
            this.notifyItemChanged(index);
        }
    }

    @Deprecated
    public void changeFooter(int groupPosition) {
        this.notifyFooterChanged(groupPosition);
    }

    public void notifyFooterChanged(int groupPosition) {
        int index = this.getPositionForGroupFooter(groupPosition);
        if (index >= 0) {
            this.notifyItemChanged(index);
        }
    }

    @Deprecated
    public void changeChild(int groupPosition, int childPosition) {
        this.notifyChildChanged(groupPosition, childPosition);
    }

    public void notifyChildChanged(int groupPosition, int childPosition) {
        int index = this.getPositionForChild(groupPosition, childPosition);
        if (index >= 0) {
            this.notifyItemChanged(index);
        }
    }

    @Deprecated
    public void changeRangeChild(int groupPosition, int childPosition, int count) {
        this.notifyChildRangeChanged(groupPosition, childPosition, count);
    }

    public void notifyChildRangeChanged(int groupPosition, int childPosition, int count) {
        int index;
        if (groupPosition < this.mStructures.size() && (index = this.getPositionForChild(groupPosition, childPosition)) >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            if (structure.getChildrenCount() >= childPosition + count) {
                this.notifyItemRangeChanged(index, count);
            } else {
                this.notifyItemRangeChanged(index, structure.getChildrenCount() - childPosition);
            }
        }
    }

    @Deprecated
    public void changeChildren(int groupPosition) {
        this.notifyChildrenChanged(groupPosition);
    }

    public void notifyChildrenChanged(int groupPosition) {
        int index;
        if (groupPosition >= 0 && groupPosition < this.mStructures.size() && (index = this.getPositionForChild(groupPosition, 0)) >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            this.notifyItemRangeChanged(index, structure.getChildrenCount());
        }
    }

    @Deprecated
    public void removeAll() {
        this.notifyDataRemoved();
    }

    public void notifyDataRemoved() {
        int count = this.countGroupRangeItem(0, this.mStructures.size());
        this.mStructures.clear();
        this.notifyItemRangeRemoved(0, count);
    }

    @Deprecated
    public void removeGroup(int groupPosition) {
        this.notifyGroupRemoved(groupPosition);
    }

    public void notifyGroupRemoved(int groupPosition) {
        int index = this.getPositionForGroup(groupPosition);
        int itemCount = this.countGroupItem(groupPosition);
        if (index >= 0 && itemCount > 0) {
            this.mStructures.remove(groupPosition);
            this.notifyItemRangeRemoved(index, itemCount);
        }
    }

    @Deprecated
    public void removeRangeGroup(int groupPosition, int count) {
        this.notifyGroupRangeRemoved(groupPosition, count);
    }

    public void notifyGroupRangeRemoved(int groupPosition, int count) {
        int index = this.getPositionForGroup(groupPosition);
        int itemCount = 0;
        itemCount = groupPosition + count <= this.mStructures.size() ? this.countGroupRangeItem(groupPosition, groupPosition + count) : this.countGroupRangeItem(groupPosition, this.mStructures.size());
        if (index >= 0 && itemCount > 0) {
            this.mStructures.remove(groupPosition);
            this.notifyItemRangeRemoved(index, itemCount);
        }
    }

    @Deprecated
    public void removeHeader(int groupPosition) {
        this.notifyHeaderRemoved(groupPosition);
    }

    public void notifyHeaderRemoved(int groupPosition) {
        int index = this.getPositionForGroupHeader(groupPosition);
        if (index >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            structure.setHasHeader(false);
            this.notifyItemRemoved(index);
        }
    }

    @Deprecated
    public void removeFooter(int groupPosition) {
        this.notifyFooterRemoved(groupPosition);
    }

    public void notifyFooterRemoved(int groupPosition) {
        int index = this.getPositionForGroupFooter(groupPosition);
        if (index >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            structure.setHasFooter(false);
            this.notifyItemRemoved(index);
        }
    }

    @Deprecated
    public void removeChild(int groupPosition, int childPosition) {
        this.notifyChildRemoved(groupPosition, childPosition);
    }

    public void notifyChildRemoved(int groupPosition, int childPosition) {
        int index = this.getPositionForChild(groupPosition, childPosition);
        if (index >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            structure.setChildrenCount(structure.getChildrenCount() - 1);
            this.notifyItemRemoved(index);
        }
    }

    @Deprecated
    public void removeRangeChild(int groupPosition, int childPosition, int count) {
        this.notifyChildRangeRemoved(groupPosition, childPosition, count);
    }

    public void notifyChildRangeRemoved(int groupPosition, int childPosition, int count) {
        int index;
        if (groupPosition < this.mStructures.size() && (index = this.getPositionForChild(groupPosition, childPosition)) >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            int childCount = structure.getChildrenCount();
            int removeCount = count;
            if (childCount < childPosition + count) {
                removeCount = childCount - childPosition;
            }
            structure.setChildrenCount(childCount - removeCount);
            this.notifyItemRangeRemoved(index, removeCount);
        }
    }

    @Deprecated
    public void removeChildren(int groupPosition) {
        this.notifyChildrenRemoved(groupPosition);
    }

    public void notifyChildrenRemoved(int groupPosition) {
        int index;
        if (groupPosition < this.mStructures.size() && (index = this.getPositionForChild(groupPosition, 0)) >= 0) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            int itemCount = structure.getChildrenCount();
            structure.setChildrenCount(0);
            this.notifyItemRangeRemoved(index, itemCount);
        }
    }

    @Deprecated
    public void insertGroup(int groupPosition) {
        this.notifyGroupInserted(groupPosition);
    }

    public void notifyGroupInserted(int groupPosition) {
        GroupStructure structure = new GroupStructure(this.hasHeader(groupPosition), this.hasFooter(groupPosition), this.getChildrenCount(groupPosition));
        if (groupPosition < this.mStructures.size()) {
            this.mStructures.add(groupPosition, structure);
        } else {
            this.mStructures.add(structure);
            groupPosition = this.mStructures.size() - 1;
        }
        int index = this.countGroupRangeItem(0, groupPosition);
        int itemCount = this.countGroupItem(groupPosition);
        if (itemCount > 0) {
            this.notifyItemRangeInserted(index, itemCount);
        }
    }

    @Deprecated
    public void insertRangeGroup(int groupPosition, int count) {
        this.notifyGroupRangeInserted(groupPosition, count);
    }

    public void notifyGroupRangeInserted(int groupPosition, int count) {
        ArrayList<GroupStructure> list = new ArrayList<GroupStructure>();
        for (int i = 0; i < count; ++i) {
            GroupStructure structure = new GroupStructure(this.hasHeader(i), this.hasFooter(i), this.getChildrenCount(i));
            list.add(structure);
        }
        if (groupPosition < this.mStructures.size()) {
            this.mStructures.addAll(groupPosition, list);
        } else {
            this.mStructures.addAll(list);
            groupPosition = this.mStructures.size() - list.size();
        }
        int index = this.countGroupRangeItem(0, groupPosition);
        int itemCount = this.countGroupRangeItem(groupPosition, count);
        if (itemCount > 0) {
            this.notifyItemRangeInserted(index, itemCount);
        }
    }

    @Deprecated
    public void insertHeader(int groupPosition) {
        this.notifyHeaderInserted(groupPosition);
    }

    public void notifyHeaderInserted(int groupPosition) {
        if (groupPosition < this.mStructures.size() && 0 > this.getPositionForGroupHeader(groupPosition)) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            structure.setHasHeader(true);
            int index = this.countGroupRangeItem(0, groupPosition);
            this.notifyItemInserted(index);
        }
    }

    @Deprecated
    public void insertFooter(int groupPosition) {
        this.notifyFooterInserted(groupPosition);
    }

    public void notifyFooterInserted(int groupPosition) {
        if (groupPosition < this.mStructures.size() && 0 > this.getPositionForGroupFooter(groupPosition)) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            structure.setHasFooter(true);
            int index = this.countGroupRangeItem(0, groupPosition + 1);
            this.notifyItemInserted(index);
        }
    }

    @Deprecated
    public void insertChild(int groupPosition, int childPosition) {
        this.notifyChildInserted(groupPosition, childPosition);
    }

    public void notifyChildInserted(int groupPosition, int childPosition) {
        if (groupPosition < this.mStructures.size()) {
            GroupStructure structure = this.mStructures.get(groupPosition);
            int index = this.getPositionForChild(groupPosition, childPosition);
            if (index < 0) {
                index = this.countGroupRangeItem(0, groupPosition);
                index += structure.hasHeader() ? 1 : 0;
                index += structure.getChildrenCount();
            }
            structure.setChildrenCount(structure.getChildrenCount() + 1);
            this.notifyItemInserted(index);
        }
    }

    @Deprecated
    public void insertRangeChild(int groupPosition, int childPosition, int count) {
        this.notifyChildRangeInserted(groupPosition, childPosition, count);
    }

    public void notifyChildRangeInserted(int groupPosition, int childPosition, int count) {
        if (groupPosition < this.mStructures.size()) {
            int index = this.countGroupRangeItem(0, groupPosition);
            GroupStructure structure = this.mStructures.get(groupPosition);
            if (structure.hasHeader()) {
                ++index;
            }
            index = childPosition < structure.getChildrenCount() ? (index += childPosition) : (index += structure.getChildrenCount());
            if (count > 0) {
                structure.setChildrenCount(structure.getChildrenCount() + count);
                this.notifyItemRangeInserted(index, count);
            }
        }
    }

    @Deprecated
    public void insertChildren(int groupPosition) {
        this.notifyChildrenInserted(groupPosition);
    }

    public void notifyChildrenInserted(int groupPosition) {
        if (groupPosition < this.mStructures.size()) {
            int itemCount;
            int index = this.countGroupRangeItem(0, groupPosition);
            GroupStructure structure = this.mStructures.get(groupPosition);
            if (structure.hasHeader()) {
                ++index;
            }
            if ((itemCount = this.getChildrenCount(groupPosition)) > 0) {
                structure.setChildrenCount(itemCount);
                this.notifyItemRangeInserted(index, itemCount);
            }
        }
    }

    public void setOnHeaderClickListener(OnHeaderClickListener listener) {
        this.mOnHeaderClickListener = listener;
    }

    public void setOnFooterClickListener(OnFooterClickListener listener) {
        this.mOnFooterClickListener = listener;
    }

    public void setOnChildClickListener(OnChildClickListener listener) {
        this.mOnChildClickListener = listener;
    }

    public abstract int getGroupCount();

    public abstract int getChildrenCount(int var1);

    public abstract boolean hasHeader(int var1);

    public abstract boolean hasFooter(int var1);

    public abstract int getHeaderLayout(int var1);

    public abstract int getFooterLayout(int var1);

    public abstract int getChildLayout(int var1);

    public abstract void onBindHeaderViewHolder(BaseViewHolder var1, int var2);

    public abstract void onBindFooterViewHolder(BaseViewHolder var1, int var2);

    public abstract void onBindChildViewHolder(BaseViewHolder var1, int var2, int var3);

    public View getEmptyView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.group_adapter_default_empty_view, parent, false);
        return view;
    }

    public static interface OnChildClickListener {
        public void onChildClick(GroupedRecyclerViewAdapter var1, BaseViewHolder var2, int var3, int var4);
    }

    public static interface OnFooterClickListener {
        public void onFooterClick(GroupedRecyclerViewAdapter var1, BaseViewHolder var2, int var3);
    }

    public static interface OnHeaderClickListener {
        public void onHeaderClick(GroupedRecyclerViewAdapter var1, BaseViewHolder var2, int var3);
    }

    class GroupDataObserver
    extends RecyclerView.AdapterDataObserver {
        GroupDataObserver() {
        }

        public void onChanged() {
            GroupedRecyclerViewAdapter.this.isDataChanged = true;
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            GroupedRecyclerViewAdapter.this.isDataChanged = true;
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.onItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            GroupedRecyclerViewAdapter.this.isDataChanged = true;
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            GroupedRecyclerViewAdapter.this.isDataChanged = true;
        }
    }
}

