/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.groupedadapter.holder;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

public class BaseViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> mViews = new SparseArray();

    public BaseViewHolder(View itemView) {
        super(itemView);
    }

    public <T extends ViewDataBinding> T getBinding() {
        return (T)DataBindingUtil.getBinding((View)this.itemView);
    }

    public <T extends View> T get(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public BaseViewHolder setText(int viewId, String text) {
        TextView tv = (TextView)this.get(viewId);
        tv.setText((CharSequence)text);
        return this;
    }

    public BaseViewHolder setText(int viewId, int textRes) {
        TextView tv = (TextView)this.get(viewId);
        tv.setText(textRes);
        return this;
    }

    public BaseViewHolder setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.get(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public BaseViewHolder setTextSize(int viewId, int size) {
        TextView view = (TextView)this.get(viewId);
        view.setTextSize((float)size);
        return this;
    }

    public BaseViewHolder setImageResource(int viewId, int resId) {
        ImageView view = (ImageView)this.get(viewId);
        view.setImageResource(resId);
        return this;
    }

    public BaseViewHolder setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.get(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public BaseViewHolder setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.get(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public BaseViewHolder setBackgroundColor(int viewId, int color) {
        Object view = this.get(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public BaseViewHolder setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.get(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public BaseViewHolder setVisible(int viewId, boolean visible) {
        Object view = this.get(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public BaseViewHolder setVisible(int viewId, int visible) {
        Object view = this.get(viewId);
        view.setVisibility(visible);
        return this;
    }
}

