/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.groupedadapter.layoutmanger;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.util.AttributeSet;
import com.donkingliang.groupedadapter.adapter.GroupedRecyclerViewAdapter;

public class GroupedGridLayoutManager
extends GridLayoutManager {
    private GroupedRecyclerViewAdapter mAdapter;

    public GroupedGridLayoutManager(Context context, int spanCount, GroupedRecyclerViewAdapter adapter) {
        super(context, spanCount);
        this.mAdapter = adapter;
        this.setSpanSizeLookup();
    }

    public GroupedGridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout, GroupedRecyclerViewAdapter adapter) {
        super(context, spanCount, orientation, reverseLayout);
        this.mAdapter = adapter;
        this.setSpanSizeLookup();
    }

    public GroupedGridLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, GroupedRecyclerViewAdapter adapter) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mAdapter = adapter;
        this.setSpanSizeLookup();
    }

    private void setSpanSizeLookup() {
        super.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                int type;
                int count = GroupedGridLayoutManager.this.getSpanCount();
                if (GroupedGridLayoutManager.this.mAdapter != null && (type = GroupedGridLayoutManager.this.mAdapter.judgeType(position)) == GroupedRecyclerViewAdapter.TYPE_CHILD) {
                    int groupPosition = GroupedGridLayoutManager.this.mAdapter.getGroupPositionForPosition(position);
                    int childPosition = GroupedGridLayoutManager.this.mAdapter.getChildPositionForPosition(groupPosition, position);
                    return GroupedGridLayoutManager.this.getChildSpanSize(groupPosition, childPosition);
                }
                return count;
            }
        });
    }

    public int getChildSpanSize(int groupPosition, int childPosition) {
        return 1;
    }

    public void setSpanSizeLookup(GridLayoutManager.SpanSizeLookup spanSizeLookup) {
    }
}

