/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.drawabletoolbox;

import android.content.res.ColorStateList;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.Build;
import android.util.StateSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.defaults.drawabletoolbox.CompatibleKt;
import top.defaults.drawabletoolbox.DrawableWrapperBuilder;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltop/defaults/drawabletoolbox/RippleDrawableBuilder;", "Ltop/defaults/drawabletoolbox/DrawableWrapperBuilder;", "()V", "color", "", "colorStateList", "Landroid/content/res/ColorStateList;", "radius", "build", "Landroid/graphics/drawable/Drawable;", "drawabletoolbox_release"})
public final class RippleDrawableBuilder
extends DrawableWrapperBuilder<RippleDrawableBuilder> {
    private int color = -4560696;
    private ColorStateList colorStateList;
    private int radius = -1;

    @NotNull
    public final RippleDrawableBuilder color(int color) {
        RippleDrawableBuilder rippleDrawableBuilder;
        RippleDrawableBuilder $receiver = rippleDrawableBuilder = this;
        $receiver.color = color;
        return rippleDrawableBuilder;
    }

    @NotNull
    public final RippleDrawableBuilder colorStateList(@Nullable ColorStateList colorStateList) {
        RippleDrawableBuilder rippleDrawableBuilder;
        RippleDrawableBuilder $receiver = rippleDrawableBuilder = this;
        $receiver.colorStateList = colorStateList;
        return rippleDrawableBuilder;
    }

    @NotNull
    public final RippleDrawableBuilder radius(int radius) {
        RippleDrawableBuilder rippleDrawableBuilder;
        RippleDrawableBuilder $receiver = rippleDrawableBuilder = this;
        $receiver.radius = radius;
        return rippleDrawableBuilder;
    }

    @Override
    @NotNull
    public Drawable build() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            Intrinsics.throwNpe();
        }
        Drawable drawable2 = drawable;
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable.ConstantState state;
            Drawable mask;
            ColorStateList colorStateList = this.colorStateList;
            if (colorStateList == null) {
                colorStateList = new ColorStateList((int[][])new int[][]{StateSet.WILD_CARD}, new int[]{this.color});
            }
            ColorStateList colorStateList2 = colorStateList;
            Drawable drawable3 = mask = drawable2 instanceof DrawableContainer ? drawable2.getCurrent() : drawable2;
            if (mask instanceof ShapeDrawable) {
                state = mask.getConstantState();
                if (state != null) {
                    Drawable drawable4 = state.newDrawable().mutate();
                    if (drawable4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.ShapeDrawable");
                    }
                    ShapeDrawable temp = (ShapeDrawable)drawable4;
                    Paint paint = temp.getPaint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)paint, (String)"temp.paint");
                    paint.setColor(-16777216);
                    mask = (Drawable)temp;
                }
            } else if (mask instanceof GradientDrawable) {
                state = mask.getConstantState();
                if (state != null) {
                    Drawable drawable5 = state.newDrawable().mutate();
                    if (drawable5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    GradientDrawable temp = (GradientDrawable)drawable5;
                    temp.setColor(-16777216);
                    mask = (Drawable)temp;
                }
            } else {
                mask = (Drawable)new ColorDrawable(-16777216);
            }
            RippleDrawable rippleDrawable = new RippleDrawable(colorStateList2, drawable2, mask);
            CompatibleKt.setRadius(rippleDrawable, this.radius);
            rippleDrawable.invalidateSelf();
            drawable2 = (Drawable)rippleDrawable;
        }
        return drawable2;
    }
}

