/*
 * Decompiled with CFR 0.152.
 */
package echo;

import echo.CharacterOutput;
import echo.MessageExtractor;
import echo.output.EchoOutput;
import echo.output.EchoOutputWrapper;
import echo.output.PluginLog;
import echo.parameter.PluginParameters;
import echo.util.FileUtil;

class EchoPlugin {
    private final PluginLog mavenPluginLog;
    private final EchoOutputWrapper echoOutput;
    private final FileUtil fileUtil;
    private final MessageExtractor messageExtractor;
    private final CharacterOutput characterOutput;
    private final boolean writeMessageToFile;

    public EchoPlugin(PluginLog mavenPluginLog, PluginParameters pluginParameters, EchoOutput echoOutput) {
        this.mavenPluginLog = mavenPluginLog;
        this.echoOutput = new EchoOutputWrapper(echoOutput, pluginParameters);
        this.fileUtil = new FileUtil(pluginParameters, mavenPluginLog);
        this.messageExtractor = new MessageExtractor(pluginParameters, this.fileUtil);
        this.characterOutput = new CharacterOutput(pluginParameters);
        this.writeMessageToFile = pluginParameters.getToFile() != null;
    }

    public void echo() {
        String messageWithCorrectNewlines = this.messageExtractor.getFormattedMessage();
        if (this.characterOutput.isWriteOutput()) {
            String characterArray = this.characterOutput.getOutput(this.messageExtractor.getOriginalMessage());
            this.mavenPluginLog.info(characterArray);
        }
        if (this.writeMessageToFile) {
            this.fileUtil.saveToFile(messageWithCorrectNewlines);
        } else {
            this.echoOutput.output(messageWithCorrectNewlines);
        }
    }
}

