/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.window;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import com.hjq.window.EasyWindow;

final class ActivityWindowLifecycle
implements Application.ActivityLifecycleCallbacks {
    private Activity mActivity;
    private EasyWindow<?> mWindow;

    ActivityWindowLifecycle(EasyWindow<?> window, Activity activity) {
        this.mActivity = activity;
        this.mWindow = window;
    }

    void register() {
        if (this.mActivity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.mActivity.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            this.mActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    void unregister() {
        if (this.mActivity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.mActivity.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (this.mActivity != activity || !this.mActivity.isFinishing() || this.mWindow == null || !this.mWindow.isShowing()) {
            return;
        }
        this.mWindow.cancel();
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.mActivity = null;
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.recycle();
        this.mWindow = null;
    }
}

