/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.window;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.window.ActivityWindowLifecycle;
import com.hjq.window.ScreenOrientationMonitor;
import com.hjq.window.ViewClickWrapper;
import com.hjq.window.ViewLongClickWrapper;
import com.hjq.window.ViewTouchWrapper;
import com.hjq.window.WindowLayout;
import com.hjq.window.draggable.BaseDraggable;
import com.hjq.window.draggable.MovingDraggable;

public class EasyWindow<X extends EasyWindow<?>>
implements Runnable,
ScreenOrientationMonitor.OnScreenOrientationCallback {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private Context mContext;
    private ViewGroup mDecorView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowParams;
    private boolean mShowing;
    private int mDuration;
    private ActivityWindowLifecycle mLifecycle;
    private BaseDraggable mDraggable;
    private OnWindowLifecycle mListener;
    private ScreenOrientationMonitor mScreenOrientationMonitor;
    private final Runnable mUpdateRunnable = this::update;

    public EasyWindow(Activity activity) {
        this((Context)activity);
        Window window = activity.getWindow();
        View decorView = window.getDecorView();
        WindowManager.LayoutParams params = activity.getWindow().getAttributes();
        if ((params.flags & 0x400) != 0 || (decorView.getSystemUiVisibility() & 4) != 0) {
            this.addWindowFlags(1024);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            this.setLayoutInDisplayCutoutMode(params.layoutInDisplayCutoutMode);
        }
        if (params.systemUiVisibility != 0) {
            this.setSystemUiVisibility(params.systemUiVisibility);
        }
        if (decorView.getSystemUiVisibility() != 0) {
            this.mDecorView.setSystemUiVisibility(decorView.getSystemUiVisibility());
        }
        this.mLifecycle = new ActivityWindowLifecycle(this, activity);
    }

    public EasyWindow(Application application) {
        this((Context)application);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setWindowType(2038);
        } else {
            this.setWindowType(2003);
        }
    }

    private EasyWindow(Context context) {
        this.mContext = context;
        this.mDecorView = new WindowLayout(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mWindowParams = new WindowManager.LayoutParams();
        this.mWindowParams.height = -2;
        this.mWindowParams.width = -2;
        this.mWindowParams.format = -3;
        this.mWindowParams.windowAnimations = 16973828;
        this.mWindowParams.packageName = context.getPackageName();
        this.mWindowParams.flags = 40;
    }

    public X setWidth(int width) {
        View contentView;
        ViewGroup.LayoutParams layoutParams;
        this.mWindowParams.width = width;
        if (this.mDecorView.getChildCount() > 0 && (layoutParams = (contentView = this.mDecorView.getChildAt(0)).getLayoutParams()) != null && layoutParams.width != width) {
            layoutParams.width = width;
            contentView.setLayoutParams(layoutParams);
        }
        this.postUpdate();
        return (X)this;
    }

    public X setHeight(int height) {
        View contentView;
        ViewGroup.LayoutParams layoutParams;
        this.mWindowParams.height = height;
        if (this.mDecorView.getChildCount() > 0 && (layoutParams = (contentView = this.mDecorView.getChildAt(0)).getLayoutParams()) != null && layoutParams.height != height) {
            layoutParams.height = height;
            contentView.setLayoutParams(layoutParams);
        }
        this.postUpdate();
        return (X)this;
    }

    public X setGravity(int gravity) {
        this.mWindowParams.gravity = gravity;
        this.postUpdate();
        this.post(() -> {
            if (this.mDraggable != null) {
                this.mDraggable.refreshLocationCoordinate();
            }
        });
        return (X)this;
    }

    public X setXOffset(int px) {
        this.mWindowParams.x = px;
        this.postUpdate();
        this.post(() -> {
            if (this.mDraggable != null) {
                this.mDraggable.refreshLocationCoordinate();
            }
        });
        return (X)this;
    }

    public X setYOffset(int px) {
        this.mWindowParams.y = px;
        this.postUpdate();
        this.post(() -> {
            if (this.mDraggable != null) {
                this.mDraggable.refreshLocationCoordinate();
            }
        });
        return (X)this;
    }

    public X setOutsideTouchable(boolean touchable) {
        int flags = 40;
        if (touchable) {
            this.addWindowFlags(flags);
        } else {
            this.removeWindowFlags(flags);
        }
        this.postUpdate();
        return (X)this;
    }

    public X setBackgroundDimAmount(float amount) {
        if (amount < 0.0f || amount > 1.0f) {
            throw new IllegalArgumentException("amount must be a value between 0 and 1");
        }
        this.mWindowParams.dimAmount = amount;
        int flags = 2;
        if (amount != 0.0f) {
            this.addWindowFlags(flags);
        } else {
            this.removeWindowFlags(flags);
        }
        this.postUpdate();
        return (X)this;
    }

    public X addWindowFlags(int flags) {
        this.mWindowParams.flags |= flags;
        this.postUpdate();
        return (X)this;
    }

    public X removeWindowFlags(int flags) {
        this.mWindowParams.flags &= ~flags;
        this.postUpdate();
        return (X)this;
    }

    public X setWindowFlags(int flags) {
        this.mWindowParams.flags = flags;
        this.postUpdate();
        return (X)this;
    }

    public boolean hasWindowFlags(int flags) {
        return (this.mWindowParams.flags & flags) != 0;
    }

    public X setWindowType(int type) {
        this.mWindowParams.type = type;
        this.postUpdate();
        return (X)this;
    }

    public X setAnimStyle(int id2) {
        this.mWindowParams.windowAnimations = id2;
        this.postUpdate();
        return (X)this;
    }

    public X setSoftInputMode(int mode) {
        this.mWindowParams.softInputMode = mode;
        this.removeWindowFlags(8);
        this.postUpdate();
        return (X)this;
    }

    public X setWindowToken(IBinder token) {
        this.mWindowParams.token = token;
        this.postUpdate();
        return (X)this;
    }

    public X setWindowAlpha(float alpha) {
        this.mWindowParams.alpha = alpha;
        this.postUpdate();
        return (X)this;
    }

    public X setVerticalMargin(float verticalMargin) {
        this.mWindowParams.verticalMargin = verticalMargin;
        this.postUpdate();
        return (X)this;
    }

    public X setHorizontalMargin(float horizontalMargin) {
        this.mWindowParams.horizontalMargin = horizontalMargin;
        this.postUpdate();
        return (X)this;
    }

    public X setBitmapFormat(int format) {
        this.mWindowParams.format = format;
        this.postUpdate();
        return (X)this;
    }

    public X setSystemUiVisibility(int systemUiVisibility) {
        this.mWindowParams.systemUiVisibility = systemUiVisibility;
        this.postUpdate();
        return (X)this;
    }

    public X setVerticalWeight(float verticalWeight) {
        this.mWindowParams.verticalWeight = verticalWeight;
        this.postUpdate();
        return (X)this;
    }

    public X setLayoutInDisplayCutoutMode(int mode) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.mWindowParams.layoutInDisplayCutoutMode = mode;
            this.postUpdate();
        }
        return (X)this;
    }

    public X setPreferredDisplayModeId(int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mWindowParams.preferredDisplayModeId = id2;
            this.postUpdate();
        }
        return (X)this;
    }

    public X setWindowTitle(CharSequence title) {
        this.mWindowParams.setTitle(title);
        this.postUpdate();
        return (X)this;
    }

    public X setScreenBrightness(float screenBrightness) {
        this.mWindowParams.screenBrightness = screenBrightness;
        this.postUpdate();
        return (X)this;
    }

    public X setButtonBrightness(float buttonBrightness) {
        this.mWindowParams.buttonBrightness = buttonBrightness;
        this.postUpdate();
        return (X)this;
    }

    public X setPreferredRefreshRate(float preferredRefreshRate) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWindowParams.preferredRefreshRate = preferredRefreshRate;
            this.postUpdate();
        }
        return (X)this;
    }

    public X setColorMode(int colorMode) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mWindowParams.setColorMode(colorMode);
            this.postUpdate();
        }
        return (X)this;
    }

    public X setBlurBehindRadius(int blurBehindRadius) {
        if (Build.VERSION.SDK_INT >= 31) {
            this.mWindowParams.setBlurBehindRadius(blurBehindRadius);
            this.addWindowFlags(4);
            this.postUpdate();
        }
        return (X)this;
    }

    public X setScreenOrientation(int orientation) {
        this.mWindowParams.screenOrientation = orientation;
        this.postUpdate();
        return (X)this;
    }

    public X setWindowParams(WindowManager.LayoutParams params) {
        this.mWindowParams = params;
        this.postUpdate();
        return (X)this;
    }

    public X setDraggable() {
        return this.setDraggable(new MovingDraggable());
    }

    public X setDraggable(BaseDraggable draggable) {
        this.mDraggable = draggable;
        if (draggable != null) {
            this.removeWindowFlags(16);
            this.removeWindowFlags(512);
            if (this.isShowing()) {
                this.update();
                draggable.start(this);
            }
        }
        if (this.mScreenOrientationMonitor == null) {
            this.mScreenOrientationMonitor = new ScreenOrientationMonitor(this.mContext.getResources().getConfiguration());
        }
        this.mScreenOrientationMonitor.registerCallback(this.mContext, this);
        return (X)this;
    }

    public X setDuration(int duration) {
        this.mDuration = duration;
        if (this.isShowing() && this.mDuration != 0) {
            this.removeCallbacks(this);
            this.postDelayed(this, this.mDuration);
        }
        return (X)this;
    }

    public X setOnToastLifecycle(OnWindowLifecycle listener) {
        this.mListener = listener;
        return (X)this;
    }

    public X setDecorView(ViewGroup viewGroup) {
        this.mDecorView = viewGroup;
        return (X)this;
    }

    public X setContentView(int id2) {
        return this.setContentView(LayoutInflater.from((Context)this.mContext).inflate(id2, this.mDecorView, false));
    }

    public X setContentView(View view) {
        if (this.mDecorView.getChildCount() > 0) {
            this.mDecorView.removeAllViews();
        }
        this.mDecorView.addView(view);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            marginLayoutParams.topMargin = 0;
            marginLayoutParams.bottomMargin = 0;
            marginLayoutParams.leftMargin = 0;
            marginLayoutParams.rightMargin = 0;
        }
        if (this.mWindowParams.gravity == 0) {
            int gravity;
            if (layoutParams instanceof FrameLayout.LayoutParams) {
                int gravity2 = ((FrameLayout.LayoutParams)layoutParams).gravity;
                if (gravity2 != -1) {
                    this.mWindowParams.gravity = gravity2;
                }
            } else if (layoutParams instanceof LinearLayout.LayoutParams && (gravity = ((LinearLayout.LayoutParams)layoutParams).gravity) != -1) {
                this.mWindowParams.gravity = gravity;
            }
            if (this.mWindowParams.gravity == 0) {
                this.mWindowParams.gravity = 17;
            }
        }
        if (layoutParams != null) {
            if (this.mWindowParams.width == -2 && this.mWindowParams.height == -2) {
                this.mWindowParams.width = layoutParams.width;
                this.mWindowParams.height = layoutParams.height;
            } else {
                layoutParams.width = this.mWindowParams.width;
                layoutParams.height = this.mWindowParams.height;
            }
        }
        this.postUpdate();
        return (X)this;
    }

    public void showAsDropDown(View anchorView) {
        this.showAsDropDown(anchorView, 80);
    }

    public void showAsDropDown(View anchorView, int showGravity) {
        this.showAsDropDown(anchorView, showGravity, 0, 0);
    }

    public void showAsDropDown(View anchorView, int showGravity, int xOff, int yOff) {
        if (this.mDecorView.getChildCount() == 0 || this.mWindowParams == null) {
            throw new IllegalArgumentException("WindowParams and view cannot be empty");
        }
        if (Build.VERSION.SDK_INT >= 17) {
            showGravity = Gravity.getAbsoluteGravity((int)showGravity, (int)anchorView.getResources().getConfiguration().getLayoutDirection());
        }
        int[] anchorViewLocation = new int[2];
        anchorView.getLocationOnScreen(anchorViewLocation);
        Rect windowVisibleRect = new Rect();
        anchorView.getWindowVisibleDisplayFrame(windowVisibleRect);
        this.mWindowParams.gravity = 0x800033;
        this.mWindowParams.x = anchorViewLocation[0] - windowVisibleRect.left + xOff;
        this.mWindowParams.y = anchorViewLocation[1] - windowVisibleRect.top + yOff;
        if ((showGravity & 3) == 3) {
            int rootViewWidth = this.mDecorView.getWidth();
            if (rootViewWidth == 0) {
                rootViewWidth = this.mDecorView.getMeasuredWidth();
            }
            if (rootViewWidth == 0) {
                this.mDecorView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                rootViewWidth = this.mDecorView.getMeasuredWidth();
            }
            this.mWindowParams.x -= rootViewWidth;
        } else if ((showGravity & 5) == 5) {
            this.mWindowParams.x += anchorView.getWidth();
        }
        if ((showGravity & 0x30) == 48) {
            int rootViewHeight = this.mDecorView.getHeight();
            if (rootViewHeight == 0) {
                rootViewHeight = this.mDecorView.getMeasuredHeight();
            }
            if (rootViewHeight == 0) {
                this.mDecorView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                rootViewHeight = this.mDecorView.getMeasuredHeight();
            }
            this.mWindowParams.y -= rootViewHeight;
        } else if ((showGravity & 0x50) == 80) {
            this.mWindowParams.y += anchorView.getHeight();
        }
        this.show();
    }

    public void show() {
        Activity activity;
        if (this.mDecorView.getChildCount() == 0 || this.mWindowParams == null) {
            throw new IllegalArgumentException("WindowParams and view cannot be empty");
        }
        if (this.mShowing) {
            this.update();
            return;
        }
        if (this.mContext instanceof Activity && ((activity = (Activity)this.mContext).isFinishing() || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed())) {
            return;
        }
        try {
            if (this.mDecorView.getParent() != null) {
                this.mWindowManager.removeViewImmediate((View)this.mDecorView);
            }
            this.mWindowManager.addView((View)this.mDecorView, (ViewGroup.LayoutParams)this.mWindowParams);
            this.mShowing = true;
            if (this.mDuration != 0) {
                this.removeCallbacks(this);
                this.postDelayed(this, this.mDuration);
            }
            if (this.mDraggable != null) {
                this.mDraggable.start(this);
            }
            if (this.mLifecycle != null) {
                this.mLifecycle.register();
            }
            if (this.mListener != null) {
                this.mListener.onWindowShow(this);
            }
        }
        catch (WindowManager.BadTokenException | IllegalArgumentException | IllegalStateException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        if (!this.mShowing) {
            return;
        }
        try {
            if (this.mLifecycle != null) {
                this.mLifecycle.unregister();
            }
            this.mWindowManager.removeViewImmediate((View)this.mDecorView);
            this.removeCallbacks(this);
            if (this.mListener != null) {
                this.mListener.onWindowCancel(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            e.printStackTrace();
        }
        finally {
            this.mShowing = false;
        }
    }

    public void postUpdate() {
        if (!this.isShowing()) {
            return;
        }
        this.removeCallbacks(this.mUpdateRunnable);
        this.post(this.mUpdateRunnable);
    }

    public void update() {
        if (!this.isShowing()) {
            return;
        }
        try {
            this.mWindowManager.updateViewLayout((View)this.mDecorView, (ViewGroup.LayoutParams)this.mWindowParams);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void recycle() {
        if (this.isShowing()) {
            this.cancel();
        }
        if (this.mScreenOrientationMonitor != null) {
            this.mScreenOrientationMonitor.unregisterCallback(this.mContext);
        }
        if (this.mListener != null) {
            this.mListener.onWindowRecycler(this);
        }
        this.mListener = null;
        this.mContext = null;
        this.mDecorView = null;
        this.mWindowManager = null;
        this.mWindowParams = null;
        this.mLifecycle = null;
        this.mDraggable = null;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public WindowManager.LayoutParams getWindowParams() {
        return this.mWindowParams;
    }

    public BaseDraggable getDraggable() {
        return this.mDraggable;
    }

    public Context getContext() {
        return this.mContext;
    }

    public View getDecorView() {
        return this.mDecorView;
    }

    public View getContentView() {
        if (this.mDecorView.getChildCount() == 0) {
            return null;
        }
        return this.mDecorView.getChildAt(0);
    }

    public <V extends View> V findViewById(int id2) {
        return (V)this.mDecorView.findViewById(id2);
    }

    public void startActivity(Class<? extends Activity> clazz) {
        this.startActivity(new Intent(this.mContext, clazz));
    }

    public void startActivity(Intent intent) {
        if (!(this.mContext instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        this.mContext.startActivity(intent);
    }

    public X setVisibility(int id2, int visibility) {
        this.findViewById(id2).setVisibility(visibility);
        return (X)this;
    }

    public X setText(int id2) {
        return this.setText(16908299, id2);
    }

    public X setText(int viewId, int stringId) {
        return this.setText(viewId, this.mContext.getResources().getString(stringId));
    }

    public X setText(CharSequence text) {
        return this.setText(16908299, text);
    }

    public X setText(int id2, CharSequence text) {
        ((TextView)this.findViewById(id2)).setText(text);
        return (X)this;
    }

    public X setTextColor(int id2, int color) {
        ((TextView)this.findViewById(id2)).setTextColor(color);
        return (X)this;
    }

    public X setTextSize(int id2, float size) {
        ((TextView)this.findViewById(id2)).setTextSize(size);
        return (X)this;
    }

    public X setTextSize(int id2, int unit, float size) {
        ((TextView)this.findViewById(id2)).setTextSize(unit, size);
        return (X)this;
    }

    public X setHint(int viewId, int stringId) {
        return this.setHint(viewId, this.mContext.getResources().getString(stringId));
    }

    public X setHint(int id2, CharSequence text) {
        ((TextView)this.findViewById(id2)).setHint(text);
        return (X)this;
    }

    public X setHintColor(int id2, int color) {
        ((TextView)this.findViewById(id2)).setHintTextColor(color);
        return (X)this;
    }

    public X setBackground(int viewId, int drawableId) {
        Drawable drawable = Build.VERSION.SDK_INT >= 21 ? this.mContext.getDrawable(drawableId) : this.mContext.getResources().getDrawable(drawableId);
        return this.setBackground(viewId, drawable);
    }

    public X setBackground(int id2, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.findViewById(id2).setBackground(drawable);
        } else {
            this.findViewById(id2).setBackgroundDrawable(drawable);
        }
        return (X)this;
    }

    public X setImageDrawable(int viewId, int drawableId) {
        Drawable drawable = Build.VERSION.SDK_INT >= 21 ? this.mContext.getDrawable(drawableId) : this.mContext.getResources().getDrawable(drawableId);
        return this.setImageDrawable(viewId, drawable);
    }

    public X setImageDrawable(int viewId, Drawable drawable) {
        ((ImageView)this.findViewById(viewId)).setImageDrawable(drawable);
        return (X)this;
    }

    public Handler getHandler() {
        return HANDLER;
    }

    public boolean post(Runnable runnable) {
        return this.postDelayed(runnable, 0L);
    }

    public boolean postDelayed(Runnable runnable, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.postAtTime(runnable, SystemClock.uptimeMillis() + delayMillis);
    }

    public boolean postAtTime(Runnable runnable, long uptimeMillis) {
        return HANDLER.postAtTime(runnable, (Object)this, uptimeMillis);
    }

    public void removeCallbacks(Runnable runnable) {
        HANDLER.removeCallbacks(runnable);
    }

    public void removeCallbacksAndMessages() {
        HANDLER.removeCallbacksAndMessages((Object)this);
    }

    public X setOnClickListener(OnClickListener<? extends View> listener) {
        return this.setOnClickListener((View)this.mDecorView, listener);
    }

    public X setOnClickListener(int id2, OnClickListener<? extends View> listener) {
        return this.setOnClickListener((View)this.findViewById(id2), listener);
    }

    private X setOnClickListener(View view, OnClickListener<? extends View> listener) {
        this.removeWindowFlags(16);
        view.setClickable(true);
        view.setOnClickListener((View.OnClickListener)new ViewClickWrapper(this, listener));
        return (X)this;
    }

    public X setOnLongClickListener(OnLongClickListener<? extends View> listener) {
        return this.setOnLongClickListener((View)this.mDecorView, listener);
    }

    public X setOnLongClickListener(int id2, OnLongClickListener<? extends View> listener) {
        return this.setOnLongClickListener((View)this.findViewById(id2), listener);
    }

    private X setOnLongClickListener(View view, OnLongClickListener<? extends View> listener) {
        this.removeWindowFlags(16);
        view.setClickable(true);
        view.setOnLongClickListener((View.OnLongClickListener)new ViewLongClickWrapper(this, listener));
        return (X)this;
    }

    public X setOnTouchListener(OnTouchListener<? extends View> listener) {
        return this.setOnTouchListener((View)this.mDecorView, listener);
    }

    public X setOnTouchListener(int id2, OnTouchListener<? extends View> listener) {
        return this.setOnTouchListener((View)this.findViewById(id2), listener);
    }

    private X setOnTouchListener(View view, OnTouchListener<? extends View> listener) {
        this.removeWindowFlags(16);
        view.setEnabled(true);
        view.setOnTouchListener((View.OnTouchListener)new ViewTouchWrapper(this, listener));
        return (X)this;
    }

    @Override
    public void run() {
        this.cancel();
    }

    @Override
    public void onScreenOrientationChange(int newOrientation) {
        if (!this.isShowing()) {
            return;
        }
        if (this.mDraggable == null) {
            return;
        }
        this.mDraggable.onScreenOrientationChange();
    }

    public static interface OnWindowLifecycle {
        default public void onWindowShow(EasyWindow<?> window) {
        }

        default public void onWindowCancel(EasyWindow<?> window) {
        }

        default public void onWindowRecycler(EasyWindow<?> window) {
        }
    }

    public static interface OnTouchListener<V extends View> {
        public boolean onTouch(EasyWindow<?> var1, V var2, MotionEvent var3);
    }

    public static interface OnLongClickListener<V extends View> {
        public boolean onLongClick(EasyWindow<?> var1, V var2);
    }

    public static interface OnClickListener<V extends View> {
        public void onClick(EasyWindow<?> var1, V var2);
    }
}

