/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.window;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;

final class ScreenOrientationMonitor
implements ComponentCallbacks {
    private int mScreenOrientation;
    private OnScreenOrientationCallback mCallback;

    public ScreenOrientationMonitor(Configuration configuration) {
        this.mScreenOrientation = configuration.orientation;
    }

    void registerCallback(Context context, OnScreenOrientationCallback callback) {
        context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
        this.mCallback = callback;
    }

    void unregisterCallback(Context context) {
        context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
        this.mCallback = null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mScreenOrientation == newConfig.orientation) {
            return;
        }
        this.mScreenOrientation = newConfig.orientation;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onScreenOrientationChange(this.mScreenOrientation);
    }

    public void onLowMemory() {
    }

    static interface OnScreenOrientationCallback {
        default public void onScreenOrientationChange(int newOrientation) {
        }
    }
}

