/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.window.draggable;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import com.hjq.window.EasyWindow;

public abstract class BaseDraggable
implements View.OnTouchListener {
    private EasyWindow<?> mWindow;
    private View mDecorView;
    private final Rect mTempRect = new Rect();
    private int mCurrentWindowWidth;
    private int mCurrentWindowHeight;
    private int mCurrentViewOnScreenX;
    private int mCurrentViewOnScreenY;
    private int mCurrentWindowInvisibleWidth;
    private int mCurrentWindowInvisibleHeight;

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void start(EasyWindow<?> window) {
        this.mWindow = window;
        this.mDecorView = window.getDecorView();
        this.mDecorView.setOnTouchListener((v, event) -> {
            this.refreshLocationCoordinate();
            return this.onTouch(v, event);
        });
        this.mDecorView.post(this::refreshLocationCoordinate);
    }

    protected EasyWindow<?> getWindow() {
        return this.mWindow;
    }

    protected View getDecorView() {
        return this.mDecorView;
    }

    protected int getWindowWidth() {
        return this.mCurrentWindowWidth;
    }

    protected int getWindowHeight() {
        return this.mCurrentWindowHeight;
    }

    protected int getWindowInvisibleWidth() {
        return this.mCurrentWindowInvisibleWidth;
    }

    protected int getWindowInvisibleHeight() {
        return this.mCurrentWindowInvisibleHeight;
    }

    public void refreshLocationCoordinate() {
        this.getDecorView().getWindowVisibleDisplayFrame(this.mTempRect);
        this.mCurrentWindowWidth = this.mTempRect.right - this.mTempRect.left;
        this.mCurrentWindowHeight = this.mTempRect.bottom - this.mTempRect.top;
        int[] location = new int[2];
        this.getDecorView().getLocationOnScreen(location);
        this.mCurrentViewOnScreenX = location[0];
        this.mCurrentViewOnScreenY = location[1];
        this.mCurrentWindowInvisibleWidth = this.mTempRect.left;
        this.mCurrentWindowInvisibleHeight = this.mTempRect.top;
    }

    public void onScreenOrientationChange() {
        float percentY;
        float percentX;
        int viewWidth = this.getDecorView().getWidth();
        int viewHeight = this.getDecorView().getHeight();
        int startX = this.mCurrentViewOnScreenX - this.mCurrentWindowInvisibleWidth;
        int startY = this.mCurrentViewOnScreenY - this.mCurrentWindowInvisibleHeight;
        if ((float)startX < 1.0f) {
            percentX = 0.0f;
        } else if ((float)Math.abs(this.mCurrentWindowWidth - (startX + viewWidth)) < 1.0f) {
            percentX = 1.0f;
        } else {
            float centerX = (float)startX + (float)viewWidth / 2.0f;
            percentX = centerX / (float)this.mCurrentWindowWidth;
        }
        if ((float)startY < 1.0f) {
            percentY = 0.0f;
        } else if ((float)Math.abs(this.mCurrentWindowHeight - (startY + viewHeight)) < 1.0f) {
            percentY = 1.0f;
        } else {
            float centerY = (float)startY + (float)viewHeight / 2.0f;
            percentY = centerY / (float)this.mCurrentWindowHeight;
        }
        this.getWindow().postDelayed(() -> {
            this.getDecorView().getWindowVisibleDisplayFrame(this.mTempRect);
            int windowWidth = this.mTempRect.right - this.mTempRect.left;
            int windowHeight = this.mTempRect.bottom - this.mTempRect.top;
            int x = (int)((float)windowWidth * percentX - (float)viewWidth / 2.0f);
            int y = (int)((float)windowHeight * percentY - (float)viewWidth / 2.0f);
            this.updateLocation(x, y);
            this.getWindow().post(this::refreshLocationCoordinate);
        }, 100L);
    }

    protected void updateLocation(float x, float y) {
        this.updateLocation((int)x, (int)y);
    }

    protected void updateLocation(int x, int y) {
        int screenGravity = 0x800033;
        WindowManager.LayoutParams params = this.mWindow.getWindowParams();
        if (params == null) {
            return;
        }
        if (params.gravity == screenGravity && params.x == x && params.y == y) {
            return;
        }
        params.x = x;
        params.y = y;
        params.gravity = screenGravity;
        this.mWindow.update();
    }

    protected boolean isFingerMove(float downX, float upX, float downY, float upY) {
        float minTouchSlop = this.getMinTouchDistance();
        return Math.abs(downX - upX) >= minTouchSlop || Math.abs(downY - upY) >= minTouchSlop;
    }

    protected float getMinTouchDistance() {
        return TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }
}

